(* structural reachability analysis with widening, narrowing, and trace *)
open Interval
open IntervalWidening
open IntervalNarrowing
open Invariant
open TransformerBounded
open IteratorTrace
let analyzer () = 
  let p1 = f1 () in
  let p2 = 
    let f x2 = f2 p1 (f3 x2) in
      let fw x2 = widen x2 (f x2) in
         let w = (lfp less EMPTY fw print) in
           let fn x2 = narrow x2 (f x2) in
              (lfp greater w fn print) in
  let p3 = f3 p2 in
  let p4 = f4 p2 in 
     pprint (p1, p2, p3, p4);;
analyzer ();;  
