(* interval.ml, interval abstract domain *)
type interval = EMPTY | INT of (int * int);;
let less x y = match x,y with
| EMPTY, _ -> true
| _, EMPTY -> false
| INT (a,b), INT (c,d) -> (c<=a)&&(b<=d);;
let greater x y = less y x;;
let join x y = match x,y with
| EMPTY, _ -> y
| _, EMPTY -> x
| INT (a,b), INT (c,d) -> INT (min a c,max b d);;
let meet x y = match x,y with
| EMPTY, _ -> EMPTY
| _, EMPTY -> EMPTY
| INT (a,b), INT (c,d) -> 
    if (b<c) || (d<a) then EMPTY
    else INT (max a c,min b d);;
let add1 x = match x with
| EMPTY -> EMPTY
| INT (a,b) ->
    (INT ((if a<max_int then a+1 else max_int),
          (if b<max_int then b+1 else max_int)));;
let print x = match x  with
| EMPTY -> print_string "_|_ "
| INT (a,b) -> print_string "(";  print_int a;  
     print_string ","; print_int b;  print_string ") ";;
let lt_sum_min_int x y =
	(* x + y < min_int *)
	if (x < 0) && (y < 0) then
		(x < min_int - y)
	else false
let gt_sum_max_int x y =
	(* x + y > max_int *)
		if (x > 0) && (y > 0) then
			(x > max_int - y)
		else false
let add x y = match x, y with
| EMPTY, _ -> EMPTY
| _, EMPTY -> EMPTY
| INT (a,b), INT (c,d) ->
    (if (gt_sum_max_int a c) then EMPTY
     else if (lt_sum_min_int b d) then EMPTY
     else 
       let l = if (lt_sum_min_int a c) then min_int else a + c
       and u = if (gt_sum_max_int b d) then max_int else b + d
       in INT (l, u));;
