
import java.applet.AudioClip;
import java.awt.*;

public class AudioApplet2 extends BufferedApplet
{
   AudioClip sound;
   Image duck;
   int w = 0, h = 0;
   boolean isAngry = true;
   int previousBeat = 0, numberOfBeats = 4;
   double beatsPerSecond = 1.2;

   double startTime;

   public void init() {
      super.init();
      sound = getAudioClip(getCodeBase(), "duck-mad.wav"); // LOAD THE SOUND FILE

      startTime = System.currentTimeMillis() / 1000.0;  // REMEMBER START TIME
   }

   public void render(Graphics g) {
      w = getWidth();
      h = getHeight();


      // THIS IS HOW WE CAN TIME THINGS BY THE SYSTEM CLOCK.

      double time = System.currentTimeMillis() / 1000.0 - startTime;

      double timeInBeats = beatsPerSecond * time;

      // In the line below we are using the "(int)" operator
      // to convert a floating point value to an integer value.

      // We are also using the "%" mod operator.

      int beat = (int)timeInBeats % numberOfBeats;

      if (beat != previousBeat) {
	 previousBeat = beat;

	 // Here is where we add any logic we'd like to
	 // do each time the beat advances.  In this case
	 // we are alternately making the audio play and
	 // stop playing.

	 if (beat == 1) {    // On this beat
	    sound.play();    // start the angry sound
	    isAngry = true;  // and turn on angry graphics.
         }

	 if (beat == 3) {    // On this beat
	    sound.stop();    // stop the angry sound
	    isAngry = false; // and turn off angry graphics.
         }
      }


      //------------- DISPLAY EVERYTHING ------------------

      // Make sure the duck image is loaded the first time.

      if (duck == null)
         duck = getImage(getCodeBase(), "duck.jpg");

      // Clear the background.

      g.setColor(Color.white);
      g.fillRect(0, 0, w, h);


      // Synchronize the duck's position to the beat.

      int x = 100 + 50 * beat;

      if (isAngry) {
         g.setColor(Color.red);
         g.fillRect(x - 50, 50, 300, 300);
	 g.setColor(Color.black);
	 g.drawString("I AM AN ANGRY DUCK!", x + 40, 35);
      }

      g.drawImage(duck, x, 100, 200, 200, this);

      if (! isAngry) {
	 g.setColor(Color.black);
	 g.drawString("I AM AN CALM DUCK.", x + 40, 325);
      }

      animating = true;
   }
}

