
/*
  This example shows you how to detect when the
  mouse has clicked down or up.
*/

import java.awt.*;

public class applet3 extends BufferedApplet
{
   /*
      The two lines below are an example of creating X and Y
      coordinates that can be used to draw or fill a polygon.

      Notice that you need two arrays: one for the
      X coordinates of the polygon, and another
      for the Y coordinates of the polygon.
   */

   int X[] = { 100, 100, 200};
   int Y[] = { 100, 200, 100};

   int w = 0, h = 0;
   int x = 100, y = 100, radius = 10;
   int dx = 5, dy = 5;

   int ballState = 0; // Keeps track of whether the ball is blue or red.

   int backgroundState = 0; // The background state starts out as zero.

   // Below is an array of colors

   Color colors[] = { Color.white, Color.green, Color.cyan };

   public void render(Graphics g) {

       w = getWidth();
       h = getHeight();

       // A mouse click DOWN sets the background state to one.

       if (! wasMouseDown && mouseDown)
          backgroundState = 1;

       // A mouse click UP sets the background state to two.

       if (wasMouseDown && ! mouseDown)
          backgroundState = 2;

       // The background color shows the background state.

       g.setColor(color[backgroundState]);

       g.fillRect(0, 0, w, h);

       // Fill a Polygon (in this case, a triangle)

       g.setColor(Color.green);
       g.fillPolygon(X, Y, 3);

       // Everytime I bounce on the floor, I will change color

       if (ballState == 0)
          g.setColor(Color.red);
       else
          g.setColor(Color.blue);

       g.fillOval(x - radius, y - radius, 2 * radius, 2 * radius);

       // Apply velocity

       x += dx;
       y += dy;

       // Bounce off right wall

       if (x >= w)
          dx = -dx;

       // Bounce off floor or accelarate

       if (y >= h) {
          dy = -dy;           // Bounce off floor
	  ballState = 1 - ballState;  // and change color
       }
       else                   // or
          dy++;               // accelarate.

       // Bounce off left wall

       if (x <= 0)
          dx = -dx;

       // Bounce off ceiling

       if (y <= 0)
          dy = -dy;

       // The next line force render to keep getting called,
       // even if there are no mouse events.

       animating = true;
   }
}

