
/*
  THIS EXAMPLE APPLET SHOWS YOU HOW TO
  CREATE A SIMPLE BUTTON OR TOGGLE.

  ONCE WE LEARN ABOUT CREATING OBJECTS,
  THIS IS GOING TO GET A LOT SIMPLER
  AND MORE POWERFUL.
*/

import java.awt.*;

public class applet5 extends BufferedApplet
{
   int w = 0, h = 0;



   // All of the variables defining the first button

   int b1x = 100, b1y = 100, b1w = 150, b1h = 30;  // Rectangular bounds around button
   Color button1Color = new Color(200, 235, 255);  // Color of the button
   boolean isPressingButton1 = false;              // Whether the button is being pressed



   // All of the variables defining the second button (which we're using as a toggle)

   int b2x = 400, b2y = 100, b2w = 150, b2h = 30;
   Color button2Color = new Color(255, 215, 200);
   boolean isPressingButton2 = false;



   // Variables for a light bulb that is turned on and off by the toggle button

   Color lightColor = new Color(255, 255, 128);
   boolean isLightTurnedOn = false;	           // State of a "light" that is turned on or off



   public void render(Graphics g) {



       // FIND OUT THE WIDTH AND HEIGHT OF THE APPLET WINDOW.

       w = getWidth();
       h = getHeight();


       //------------------- HANDLE USER INPUT ------------------------

       /*
          WHEN THE USER CLICKS DOWN, SET EACH BUTTON'S BOOLEAN TO TRUE
	  IF THE MOUSW IS INSIDE THAT BUTTON.
       */

       if (! wasMouseDown && mouseDown) {
          isPressingButton1 = mouseX >= b1x && mouseX < b1x + b1w && mouseY >= b1y && mouseY < b1y + b1h ;
          isPressingButton2 = mouseX >= b2x && mouseX < b2x + b2w && mouseY >= b2y && mouseY < b2y + b2h ;
       }

       /*
          WHEN THE USER CLICKS UP, THEN DO ALL "CLICK UP" LOGIC.
       */

       // IF THIS IS THE MOMENT THE MOUSE BUTTON IS GOING UP,

       if (! mouseDown && wasMouseDown) {

	  // IF THE USER HAS PRESSED THE SECOND BUTTON,

	  if (isPressingButton2)

	     // IF THE MOUSE IS STILL OVER THE BUTTON,

	     if (mouseX >= b2x && mouseX < b2x + b2w && mouseY >= b2y && mouseY < b2y + b2h)

	        // FLIP THE LIGHT SWITCH ON OR OFF.

	        isLightTurnedOn = ! isLightTurnedOn;
       }

       /*
          IF THE MOUSE BUTTON IS UP, THEN NO BUTTONS ARE PRESSED.
       */

       if (! mouseDown) {
          isPressingButton1 = false;
          isPressingButton2 = false;
       }


       //------------------- DRAW EVERYTHING ---------------------



       // CLEAR THE APPLET WINDOW.

       g.setColor(Color.white);
       g.fillRect(0, 0, w, h);



       // DRAW THE TWO BUTTONS.

       g.setColor(button1Color);
       g.fill3DRect(b1x, b1y, b1w, b1h, ! isPressingButton1);

       g.setColor(Color.black);
       g.drawString("I'm a button!", b1x + 25, b1y + 20);

       g.setColor(button2Color);
       g.fill3DRect(b2x, b2y, b2w, b2h, ! isPressingButton2);

       g.setColor(Color.black);
       g.drawString("I'm a toggle!", b2x + 25, b2y + 20);



       // DRAW THE LIGHT BULB.

       // Fill the light bulb with light, if the light is on.

       if (isLightTurnedOn) {
          g.setColor(lightColor);
          g.fillOval(w / 2 - 100, h - 300, 200, 200);
       }

       // Draw the light bulb itself.

       g.setColor(Color.black);
       g.drawOval(w / 2 - 100, h - 300, 200, 200);
       g.fillOval(w / 2 - 15, h - 60, 30, 20);
       g.setColor(Color.gray);
       g.fillRect(w / 2 - 25, h - 103, 50, 53);
       g.setColor(Color.black);
       g.drawRect(w / 2 - 25, h - 103, 50, 53);
       g.drawString("I'm a light bulb!", w / 2 - 50, h - 200);



       // The next line forces render to get called repeatedly,
       // even if there are no mouse events.

       animating = true;
   }
}

