
/*
  THIS EXAMPLE APPLET SHOWS YOU HOW TO DETECT AND RESPOND
  WHEN KEYS OF THE KEYBOARD ARE CLICKED DOWN OR UP.
*/

import java.awt.*;

public class applet4 extends BufferedApplet
{
   /*
      The two lines below are an example of creating X and Y
      coordinates that can be used to draw or fill a polygon.
   */

   int X[] = { 100, 100, 200};       // Array storing the X coordinates of the triangle
   int Y[] = { 100, 200, 100};       // Array storing the Y coordinates of the triangle

   int w = 0, h = 0, x = 100, y = 100, radius = 10, dx = 5, dy = 5;
   int ballState = 0;                // Keeps track of whether the ball is blue or red.
   int backgroundState = 0;          // The background state starts out as zero.
   boolean showTriangle = false;     // Keeps track of whether the triangle is visible.
   int textCounter = 0;
   Color colors[] = { Color.white, Color.yellow, Color.cyan };    // An array of colors

   public void render(Graphics g) {

       // Find out the width and the height of the applet window.

       w = getWidth();
       h = getHeight();



       // USE MOUSE CLICKING TO CONTROL THE COLOR OF THE BACKGROUND.


       /*
          The following is something I didn't have time to
	  get to in class today: Showing how to use a mouse
	  click to CYCLE through the colors (0,1,2,0,1,2,...):
       */

       // A mouse click UP cycles the background to the next color.

       if (wasMouseDown && ! mouseDown) {
          backgroundState = backgroundState + 1;
	  if (backgroundState == 3)
	     backgroundState = 0;
       }


       // CLICK ON VARIOUS KEYS TO CONTROL THE TRIANGLE IN DIFFERENT WAYS.


       // Clicking on the '1' key turns the triangle ON.

       if (wasKeyDown['1'] && ! keyDown['1'])
          showTriangle = true;

       // Clicking on the '2' key turns the triangle OFF.

       if (wasKeyDown['2'] && ! keyDown['2'])
          showTriangle = false;

       // Clicking on the 't' key toggles the triangle.

       if (wasKeyDown['t'] && ! keyDown['t'])
          showTriangle = ! showTriangle;


/*
       // PRINTING TEXT TO STANDARD OUT AND STANDARD ERROR (COMMENTED OUT FOR NOW).


       // Printing text to standard out

       System.out.print(textCounter++ + " ");

       // Printing text to standard error

       if (textCounter == 100)
          System.err.println("text counter just reached 100");
*/


       // HANDLE THE BEHAVIOR OF THE BALL.


       // Apply velocity.

       x += dx;
       y += dy;

       // Bounce off right wall.

       if (x >= w)
          dx = -dx;

       // Bounce off floor or accelerate.

       if (y >= h) {
          dy = -dy;           // Bounce off floor
	  ballState = 1 - ballState;  // and change color
       }
       else                   // or
          dy++;               // accelerate.

       // Bounce off left wall.

       if (x <= 0)
          dx = -dx;

       // Bounce off ceiling.

       if (y <= 0)
          dy = -dy;



       // DRAW EVERYTHING


       // The background varies with the background state.

       g.setColor(colors[backgroundState]);
       g.fillRect(0, 0, w, h);

       // Fill a Polygon (in this case, a triangle).

       if (showTriangle) {
          g.setColor(Color.green);
          g.fillPolygon(X, Y, 3);
       }

       // Every time the ball bounces on the floor, it changes color.

       if (ballState == 0)
          g.setColor(Color.red);
       else
          g.setColor(Color.blue);

       g.fillOval(x - radius, y - radius, 2 * radius, 2 * radius);



       // The next line forces render to get called repeatedly,
       // even if there are no mouse events.

       animating = true;
   }
}

