
package drawable;
import java.awt.*;

public class Triangle extends Drawable
{
   int X[], Y[];
   boolean needToRecomputeVertices = true;

   public Triangle(int x, int y, int width, int height) {
      super(x, y, width, height);
   }

   public void setBounds(int x, int y, int width, int height) {

      super.setBounds(x, y, width, height);
   }

   public void move(int x, int y) {

      // WE ONLY NEED TO RECOMPUTE THE VERTICES WHEN THE TRIANGLE HAS MOVED

      super.move(x, y);
      needToRecomputeVertices = true;
   }

   public boolean contains(int px, int py) {

      // MUST BE ABOVE BOTTOM EDGE

      if (py > y + height)
         return false;

      // AND MUST BE TO RIGHT OF LEFT EDGE

      else if (px < x + width / 2) {
         double dx = (double)(px - x) / (width / 2);
         double dy = (double)(py - y) / height;
	 return dx + dy >= 1.0;
      }

      // AND MUST BE TO LEFT OF RIGHT EDGE

      else {
         double dx = (double)(px - (x + width / 2)) / (width / 2);
         double dy = (double)(py - y) / height;
	 return dx <= dy;
      }
   }

   public void draw(Graphics g) {

      // SEE WHETHER WE NEED TO RECOMPUTE VERTICES BEFORE DRAWING

      if (needToRecomputeVertices) {
         needToRecomputeVertices = false;

	 // FIRST TIME ONLY: ALLOCATE VERTEX ARRAYS

         if (X == null)
            X = new int[3];
         if (Y == null)
            Y = new int[3];

         X[0] = x;
         Y[0] = y + height;

         X[1] = x + width / 2;
         Y[1] = y;

         X[2] = x + width;
         Y[2] = y + height;
      }

      // DRAW THE TRIANGLE

      g.setColor(getColor());
      g.fillPolygon(X, Y, 3);
      g.setColor(Color.black);
      g.drawPolygon(X, Y, 3);
   }
}
