
package drawable;
import java.awt.*;

public class Disk extends Drawable
{
   public Disk(int x, int y, int width, int height) {
      super(x, y, width, height);
   }

   public void setBounds(int x, int y, int width, int height) {
      super.setBounds(x, y, width, height);
   }

   public boolean contains(int x, int y) {
      double dx = (double)(x - (this.x + width  / 2)) / (width  / 2);
      double dy = (double)(y - (this.y + height / 2)) / (height / 2);
      return dx * dx + dy * dy <= 1.0;
   }

   public void draw(Graphics g) {
      g.setColor(getColor());
      g.fillOval(x, y, width, height);
      g.setColor(Color.black);
      g.drawOval(x, y, width, height);
   }
}

