
package drawable;
import java.awt.*;

public abstract class Drawable
{
   int x, y, width, height;
   Color color = null;
   DrawableClient client;

   public void setClient(DrawableClient client) {
      this.client = client;
   }

   public Drawable() { }

   public Drawable(int x, int y, int width, int height) {
      setBounds(x, y, width, height);
   }

   public Color getColor() { return color == null ? Color.white : color; }
   public boolean hasColor() { return color != null; }
   public int getX() { return x; }
   public int getY() { return y; }
   public int getWidth() { return width; }
   public int getHeight() { return height; }

   public void setColor(Color color) { this.color = color; }
   public void setX(int x) { this.x = x; }
   public void setY(int y) { this.y = y; }

   public void move(int dx, int dy) {
      x += dx;
      y += dy;
   }

   public void moveTo(int x, int y) {
      this.x = x;
      this.y = y;
   }

   public void setBounds(int x, int y, int width, int height) {
      this.x = x;
      this.y = y;
      this.width = width;
      this.height = height;
   }

   public abstract boolean contains(int x, int y);
   public abstract void draw(Graphics g);
}

