
package drawable;
import java.awt.*;

public class Box extends Drawable
{
   public Box(int x, int y, int width, int height) {
      super(x, y, width, height);
   }

   public boolean contains(int x, int y) {
      return x >= this.x && y >= this.y && x < this.x + width && y < this.y + height;
   }

   public void draw(Graphics g) {
      g.setColor(getColor());
      g.fillRect(x, y, width, height);
      g.setColor(Color.black);
      g.drawRect(x, y, width, height);
   }
}

