package wiimote;

public class WiiEventThread2 extends Thread
{
	public WiiEvent event;
	
	public WiiEventThread2() {
		event = new WiiEvent();
	}
	
	float lerp(float t, float a, float b) {
		return a + t * (b - a);
	}
	
	public void run() {
		while (true) {
			event.x1 = WiiRemote2.x();
			event.y1 = WiiRemote2.y();
			event.z1 = WiiRemote2.z();
			
			event.x = lerp(.5f, event.x, event.x1);
			event.y = lerp(.5f, event.y, event.y1);
			event.z = lerp(.5f, event.z, event.z1);
			
			event.a = WiiRemote2.a();
			event.b = WiiRemote2.b();
			
			event.up    = WiiRemote2.up();
			event.down  = WiiRemote2.down();
			event.left  = WiiRemote2.left();
			event.right = WiiRemote2.right();
			
			event.minus = WiiRemote2.minus();
			event.home  = WiiRemote2.home();
			event.plus  = WiiRemote2.plus();
			
			event.one = WiiRemote2.one();
			event.two = WiiRemote2.two();
			
			event.ir1x = WiiRemote2.ir1x();
			event.ir1y = WiiRemote2.ir1y();
			event.ir1s = WiiRemote2.ir1s();
			
			event.ir2x = WiiRemote2.ir2x();
			event.ir2y = WiiRemote2.ir2y();
			event.ir2s = WiiRemote2.ir2s();
			
			try {
				sleep(10);
			}
			catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}