package wiimote;

public class WiiEventThread extends Thread
{
	public WiiEvent event;
	
	public WiiEventThread() {
		event = new WiiEvent();
	}
	
	float lerp(float t, float a, float b) {
		return a + t * (b - a);
	}
	
	public void run() {
		while (true) {
			event.x1 = WiiRemote.x();
			event.y1 = WiiRemote.y();
			event.z1 = WiiRemote.z();
			
			event.x = lerp(.5f, event.x, event.x1);
			event.y = lerp(.5f, event.y, event.y1);
			event.z = lerp(.5f, event.z, event.z1);
			
			event.a = WiiRemote.a();
			event.b = WiiRemote.b();
			
			event.up    = WiiRemote.up();
			event.down  = WiiRemote.down();
			event.left  = WiiRemote.left();
			event.right = WiiRemote.right();
			
			event.minus = WiiRemote.minus();
			event.home  = WiiRemote.home();
			event.plus  = WiiRemote.plus();
			
			event.one = WiiRemote.one();
			event.two = WiiRemote.two();
			
			event.ir1x = WiiRemote.ir1x();
			event.ir1y = WiiRemote.ir1y();
			event.ir1s = WiiRemote.ir1s();
			
			event.ir2x = WiiRemote.ir2x();
			event.ir2y = WiiRemote.ir2y();
			event.ir2s = WiiRemote.ir2s();
			
			try {
				sleep(10);
			}
			catch (Exception e) {
				e.printStackTrace();
			}
		}
	}
}