<?php
////////////////////////////////////////////////////////////
// include required files
////////////////////////////////////////////////////////////
include('class.Message.php');
include('class.TcpClient.php');

////////////////////////////////////////////////////////////
// check if required parameters are passed
////////////////////////////////////////////////////////////
$xml = file_get_contents("php://input");    // xml is passed from POST

if (!$xml) {
    // xml is not transfered
    header('Content-type: text/html');
    echo("No XML file is attached");
    return;
}


////////////////////////////////////////////////////////////
// variables
////////////////////////////////////////////////////////////
$pot;                               // pot
$cluster;                           // cluster
$perspon;                           // person
$proximity;                         // proximity level
$noise;                             // noise level

$msg;                               // message class
$messages = array();                // array for Message class                

$dom;                               // XML dom for response
$doms     = array();                // array for XML dom
$parser   = xml_parser_create();    // create a XML parser


////////////////////////////////////////////////////////////
// parsing XML
////////////////////////////////////////////////////////////
xml_parse_into_struct($parser, $xml, $vals, $index);    // parse xml and store to array
xml_parser_free($parser);                               // free parser

////////////////////////////////////////////////////////////
// extracts values from XML 
////////////////////////////////////////////////////////////

$idx = 0;

foreach($vals as $element) {
    
    ////////////////////////////////////////////////////////////////////
    // <messsage>                           --> type: open
    //     <event>                          --> type: open
    //         <person>xxx</person>         --> type: complete
    //         <pot>xxx</pot>               --> type: complete
    //         <cluster>xxx</cluster>       --> type: complete
    //         <proximity>xxx</proximity>   --> type: complete
    //         <noiselevel>xxx</noiselevel> --> type: complete
    //     </event>                         --> type: close
    //     ........                         ..................
    // </message>                           --> type: close
    /////////////////////////////////////////////////////////////////////
    
    $tag   = $element['tag'];
    $value = $element['value'];
    $type  = $element['type'];
    
    if ($type == "complete") {                
        // get values from xml tag
        switch ($tag) {
            case "POT":                  
                $pot = $value;          break;        
            case "CLUSTER":
                $cluster = $value;      break;
            case "PERSON":
                $person = $value;       break;
            case "PROXIMITY":
                $proximity = $value;    break;
            case "NOISELEVEL":
                $noise = $value;        break;
        }
    }
                    
    if ($type == "close" && $tag == "EVENT") {  
        
        // create a new class and store
        $msg = new Message();
        $msg->setMessage($pot, $cluster, $person, $proximity, $noise);
        
        if (array_key_exists("${pot}${cluster}", $doms)) {
            $dom = $doms["${pot}${cluster}"];
        } else {            
            $dom  = new DOMDocument("1.0");
        }
                
        //$dom->formatOutput = true;
        
        $root          = $dom->createElement("event");        
        $potElem       = $dom->createElement("pot", $pot);
        $clusterElem   = $dom->createElement("cluster", $cluster);
        $personElem    = $dom->createElement("person", $person);
        $proximityElem = $dom->createElement("proximity", $proximity);
        $noiseElem     = $dom->createElement("noiselevel", $noise);
        
        $dom->appendChild($root);        
        $root->appendChild($potElem);
        $root->appendChild($clusterElem);
        $root->appendChild($personElem);
        $root->appendChild($proximityElem);
        $root->appendChild($noiseElem);
        
        $doms["${pot}${cluster}"] = $dom;
        $messages[$idx] = $msg;
        $idx++;
    }
}

////////////////////////////////////////////////////////////
// send command to processing
////////////////////////////////////////////////////////////

$i = 0;

foreach($doms as $dom) {
        
    $server = "128.61.122.207"; 
    $port   = 9999;
    $client = new TcpClient($server, $port); 
    
    $client->Timeout = 2000;
    $client->Connect(); 
    
    if ($client->GetError()) {
        ShowError($client->GetError()); 
        continue;
    }
       
       
        
    //////////////////////////////////////////////////
    // send XML size
    //////////////////////////////////////////////////
    
    $sentByte      = 0;
    $totalSentByte = 0;
    
    $recvByte      = 9;
    $totalRecvByte = 0; 
    $recvString    = "";
           
    $xmlSize       = strlen($dom->saveXML());
    $xmlString     = $dom->saveXML();
    
    $sentByte = $client->Write("SIZE:${xmlSize}");    

    
    print("----------\n");
    print("Write         : SIZE:${xmlSize}\n");
    print("sentByte      : ${sentByte}\n");
    
    
    while($totalRecvByte < $recvByte) {        
        $recv           = $client->Read($recvByte);        
        $totalRecvByte += strlen($recv);
        $recvString     = $recvString . $recv;
    }
    
    print("Read          : ${recvString}\n");
    print("readByte      : ${totalRecvByte}\n");
    
    
    
    //////////////////////////////////////////////////
    // send XML
    //////////////////////////////////////////////////
    
    while($totalSentByte < $xmlSize) {
        $sentByte       = $client->Write(substr($xmlString, $totalSentByte));
        $totalSentByte += $sentByte;
    }
    
    print("Write         : XML\n");
    print("sentByte      : ${totalSentByte}\n");
    //print("----------\n");
    
    
    
    //////////////////////////////////////////////////
    // sen END after receiving END
    //////////////////////////////////////////////////

    $recvByte      = 3;
    $totalRecvByte = 0;
    $recvString    = "";
    
    while($totalRecvByte < $recvByte) {
        $recv           = $client->Read($recvByte);
        $totalRecvByte += strlen($recv);
        $recvString     = $recvString . $recv;
    }
    
    print("Read          : ${recvString}\n");
    print("readByte      : ${totalRecvByte}\n");
    
    $sent = $client->Write("END");
    print("Write         : END\n");
    print("sentByte      : ${sent}\n");

    $client->Close();
    sleep(1);
}

?>