
import java.awt.*;
import simpleGamePlatform.*;

/*
   This is a simple chaser/avoider game
   that we implemented in class.

   It shows the avoider reversing its x
   velocity when it collides with walls,
   or when intercepted by the chaser.

   The player gets +1 point when the avoider
   hits the right wall, and -1 point when
   the chaser hits the left wall.

   The overlay method is used to show
   the current score.
*/

public class game2 extends GamePlatform
{
   double avoiderDx = 0;

   public void setup() {
      int w = getWidth(), h = getHeight();

      avoider = new DiskPiece();
      avoider.setBounds(400, 100, 50, 50);
      avoider.setColor(Color.red);
      avoider.setLabel("avoider");
      setCollisionTracked(avoider);
      addPiece(avoider);

      chaser = new RectPiece();
      chaser.setBounds(150, 200, 60, 100);
      chaser.setColor(Color.blue);
      chaser.setLabel("chaser");
      setCollisionTracked(chaser);
      addPiece(chaser);

      addPiece(left = (new RectPiece()).setBounds(0, 0, 10, h));
      addPiece(right = (new RectPiece()).setBounds(w-10, 0, 10, h));
   }

   public void startCollision(Piece one, Piece two) {
      if (one == chaser || two == left || two == right) {
         avoiderDx *= -1;
	 avoider.setX(avoider.getX() + avoiderDx);
	 if (one != chaser) {
	    if (two == left)
	       score--;
	    if (two == right)
	       score++; 
         }
      }
      playClip("audioclips/click.wav");
   }

   public void endCollision(Piece one, Piece two) {
   }

   public void update() {
      avoiderDx += 2 * Math.random() - 1;
      avoider.setX(avoider.getX() + avoiderDx);
   }

   public void overlay(Graphics g) {
      g.setFont(font);

      g.setColor(Color.black);
      g.drawString("" + score, getWidth() / 2, 16);
   }

   int score = 0;
   Piece avoider, chaser, left, right;
   Font font = new Font("Helvetica", Font.BOLD, 16);
}

