
import render.*;

public class test2 extends RenderApplet
{
   Material goldPaint, bluePaint;
   Geometry box1, box2;

   public void initialize() {
      setBgColor(.4, .5, .8);
      addLight( 1, 1, 0, 1, 1, 1);
      addLight(-1,-1,-1, .5, .5, .5);
      addLight(-1, 0, 1, .7, .7, .7);
      addLight( 1,-1, 1, .3, .3, .3);
      addLight(-1, 1,-1, .5, .5, .5);

      // FOR METAL, KEEP AMBIENT AND DIFFUSE LOW, AND
      // MATCH SPECULAR R,G,B RATIOS TO AMBIENT AND DIFFUSE.

      goldPaint = new Material();
      goldPaint.setAmbient(0.1, 0.07, 0.01);
      goldPaint.setDiffuse(0.3, 0.2, 0.03);
      goldPaint.setSpecular(0.8, 0.6, 0.2, 5);

      // FOR PLASTIC, MAKE THE SPECULAR WHITE.

      bluePaint = new Material();
      bluePaint.setAmbient(0, 0, 0.5);
      bluePaint.setDiffuse(0, 0, 0.5, 0.85);
      bluePaint.setSpecular(1, 1, 1, 20);

      box1 = getWorld().add().sphere(16);
      box1.setMaterial(goldPaint);

      box2 = box1.add().sphere(16);
      box2.setMaterial(bluePaint);
   }

   public void animate(double time) {
      Matrix m = box2.getMatrix();
      m.identity();
      m.translate(0, 1.5, 0);
      m.scale(.5, .5, .5);
   }
}

