using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace WindowsGame2
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

////
        SoundEffect soundEffect, oopsEffect;
        SpriteFont scoreFont;
        Texture2D round_face, surprised_round_face, texture;
        Vector2 xy = new Vector2();
        double xVelocity = 10.0, yVelocity = 0, yAccelaration = 10.0;
        Boolean wasHit = false;
        int score = 0, winningScore = 3;
////

        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            // TODO: Add your initialization logic here

            base.Initialize();

////
            IsMouseVisible = true;
////
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here

////
            scoreFont = Content.Load<SpriteFont>(@"fonts\Arial");
            soundEffect = Content.Load<SoundEffect>(@"audio\doing");
            oopsEffect = Content.Load<SoundEffect>(@"audio\oops");
            round_face = Content.Load<Texture2D>(@"images\round_face");
            surprised_round_face = Content.Load<Texture2D>(@"images\surprised_round_face");
            texture = round_face;
////
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here

////
            double frameTime = gameTime.ElapsedGameTime.Milliseconds / 1000.0;
            double width  = Window.ClientBounds.Width;
            double height = Window.ClientBounds.Height;
            MouseState mouseState = Mouse.GetState();
            double r = texture.Width / 2;

            Boolean isHit = hitDisk(xy.X + r, xy.Y + r, r, mouseState.X, mouseState.Y);

            if (isHit) {
               if (! wasHit) {
                  if (score < winningScore) {
                     if (texture == surprised_round_face)
                        score++;
                     else {
                        score--;
                        oopsEffect.Play();
                     }
                     if (score < 0)
                        score = 0;
                  }
               }
            }
            else {
               yVelocity += yAccelaration * frameTime;
               double x = xy.X + xVelocity;
               double y = xy.Y + yVelocity;

               if (x >= width - texture.Width) {
                  xVelocity = -xVelocity;
                  x = width - texture.Width;
                  texture = round_face;
               }
               if (x <= 0) {
                  xVelocity = -xVelocity;
                  x = 0;
                  texture = round_face;
               }
               if (y >= height - texture.Height) {
                  yVelocity = -yVelocity;
                  y = height - texture.Height;
                  texture = surprised_round_face;
                  soundEffect.Play();
               }
               if (y <= 0) {
                  yVelocity = -yVelocity;
                  y = 0;
               }
               xy.X = (float)x;
               xy.Y = (float)y;
            }

            wasHit = isHit;
////

            base.Update(gameTime);
        }

        Boolean hitDisk(double x, double y, double r, double mx, double my) {
           mx -= x;
           my -= y;
           return mx * mx + my * my < r * r;
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.CornflowerBlue);

            // TODO: Add your drawing code here

////

            spriteBatch.Begin();
            spriteBatch.Draw(texture, xy, Color.White);
            spriteBatch.DrawString(scoreFont, score == winningScore ? "YOU WON!"
                                                                    : "Score " + score, Vector2.Zero, Color.Black);
            spriteBatch.End();

////

            base.Draw(gameTime);
        }
    }
}

