(* iteratorTrace.ml, Jacobi iteration with execution trace *)
open Invariant
let lfp leq a f print = 
  let rec iterate x =
    print x;
    let y = f x in
      if leq y x then (print_string " converged to fixpoint.";
                       print_newline (); x)
      else iterate y
  in iterate a;;
