(* iteratorPartialBoundedTrace.ml, Jacobi iteration with execution trace *)
open Invariant
let lfp leq a f = 
  let rec iterate n x =
    if (n<6) then pprint x;
    if (n=6) then (print_string " ..."; print_newline ());
    if ((n/2)>(100-2)) then pprint x;
    let y = f x in
      if leq y x then (print_string " converged to fixpoint.";
                       print_newline (); x)
      else iterate (n+1) y
  in iterate 0 a;;
