(* invariant.ml, interval invariant abstract domain *)
open Interval
type invariant = interval*interval*interval*interval;;
let cless (x1,x2,x3,x4) (x'1,x'2,x'3,x'4) = 
   (less x1 x'1, less x2 x'2, less x3 x'3, less x4 x'4);;
let pless x x' = 
   let (b1, b2, b3, b4) = cless x x' in
      b1 && b2 && b3 && b4;;
let pgreater x x' = pless x' x;;
let pbot = (EMPTY, EMPTY, EMPTY, EMPTY);;
let pmeet (x1,x2,x3,x4) (x'1,x'2,x'3,x'4) =
   (meet x1 x'1, meet x2 x'2, meet x3 x'3, meet x4 x'4);;
let pprint (x1,x2,x3,x4) = 
   print_string "1:";print x1; print_string "2:";
   print x2; print_string "3:";print x3; 
   print_string "4:";print x4; print_newline ();;
