function [iv,v] = variables(varargin)
%   variables x1 x2 x3  ... 
%      creates independant variables x10 x20 x30 (for initial values) 
%      and x1 x2 x3 ....  (for final values);
%   [iv,v] = variables('x1','x2','x3',...)  
%		creates independant variables x10 x20 x30 ...  (for initial values) 
%     in iv and x1 x2 x3 ....  (for final values) in v.
%   Note that x10 x20 x30 ... x1 x2 x3 ... are part of the matlab workspace,
%   in that order.
for i1 = 1:nargin
  if isstr(varargin{i1})
  	 iv(i1)=sdpvar(1,1);
  	 assignin('base',strcat(varargin{i1},'0'), iv(i1));
  else
    error('Inputs must be strings');
  end
end
for i1 = 1:nargin
  if isstr(varargin{i1})
  	 v(i1)=sdpvar(1,1);
  	 assignin('base',varargin{i1}, v(i1));
  else
    error('Inputs must be strings');
  end
end

   
%******************************************************************************
% Copyright 2004  Patrick.Cousot@ens.fr
%******************************************************************************
% Permission to use, copy, modify, and distribute this software and its
% documentation for any purpose and without fee is hereby granted,
% provided that the above copyright notice appear in all copies and that
% both that the copyright notice and warranty disclaimer appear in
% supporting documentation.
% 
% P. Cousot disclaims all warranties with regard to this software,
% including all implied warranties of merchantability and fitness.  In
% no event shall P. Cousot be liable for any special, indirect or
% consequential damages or any damages whatsoever resulting from loss of
% use, data or profits, whether in an action of contract, negligence or
% other tortuous action, arising out of or in connection with the use or
% performance of this software.
%******************************************************************************
