function [] = fltrank (R, v) 
% fltrank (R, v) 
%   displays the rank function R with list of variables v.
V=namesofvars(v);
Rk = double(R);
n = size(Rk,2) - 1; % number of program variables.
if n ~= size(V,1)
	error('Incorrect number of variables (%i)',n);
end;
disp(' ');
% display inequalities x R x' >= 0
Lhs = 'r(';
for i = 1:1:n-1
	Lhs = strcat(Lhs,sprintf('%s,',char(V(i))));
end;
Lhs = strcat(Lhs,sprintf('%s) = ',char(V(n))));
Rhs = '';
for i = 1:1:n+1
   for j = i:1:n+1
   	if i == n+1 & j == n+1 & Rk(n+1,n+1) ~= 0
         Rhs = strcat(Rhs,sprintf(' %+2i',Rk(n+1,n+1)));
      elseif i <= n & j == n+1 & (Rk(i,n+1)+Rk(n+1,i)) ~= 0
         Rhs = strcat(Rhs,sprintf(' %+2i.%s',(Rk(i,n+1)+Rk(n+1,i)),char(V(i))));
    	elseif i == j & i <= n & Rk(i,i) ~= 0
         [s, errmsg] = sprintf(' %+2i.%s^2',Rk(i,i),char(V(i)));
         if size(errmsg) ~= 0
         	error('%s',errmsg);
         end
   		Rhs = strcat(Rhs,s);
      elseif i <= n & j <= n & (Rk(i,j)+Rk(j,i)) ~= 0
   		Rhs = strcat(Rhs,sprintf(' %+2i.%s.%s',(Rk(i,j)+Rk(j,i)),char(V(i)),char(V(j))));
      elseif (Rk(i,j)+Rk(j,i)) ~= 0
         Rhs = strcat(Rhs,sprintf(' %+2i.%s''.%s''',(Rk(i,j)+Rk(j,i)),char(V(i-n)),char(V(j-n))));
      end
   end
end;
if size(Rhs,1) == 0
   Lhs = 'No ranking function found.'; Rhs='';
end
disp(strcat(Lhs,Rhs));

%******************************************************************************
% Copyright 2004  Patrick.Cousot@ens.fr
%******************************************************************************
% Permission to use, copy, modify, and distribute this software and its
% documentation for any purpose and without fee is hereby granted,
% provided that the above copyright notice appear in all copies and that
% both that the copyright notice and warranty disclaimer appear in
% supporting documentation.
% 
% P. Cousot disclaims all warranties with regard to this software,
% including all implied warranties of merchantability and fitness.  In
% no event shall P. Cousot be liable for any special, indirect or
% consequential damages or any damages whatsoever resulting from loss of
% use, data or profits, whether in an action of contract, negligence or
% other tortuous action, arising out of or in connection with the use or
% performance of this software.
%******************************************************************************
