function diagnostic = checktermination(iv, v, Mk, N, X, fi, radius, solver)
% diagnostic = checktermination(x0, x, Mk, N, R[, fi, radius, solver])
%   checks the rank function given by the rank matrix R for semantics
%   [B;C](x0,x)=/\k=1..N (x x_ 1) Mk(:,:,k) (x0 x 1)' >= 0 /\
%   /\k=N+1..N+M (x0 x 1) Mk(:,:,k) (x0 x 1)' = 0, with optional input 
%   arguments fi = 'float' ['int'], lq = 'quadratic' ['linear'] ranking 
%   function, rigid feasibility radius [inf=none] and solver 'lmilab' 
%   ['csdp', sdpt3', 'sedumi', 'sdplr', ...].
%      Returns a feasibility diagnostic on the termination proof 
%   for the given ranking function r(x) = xRx'.

% format rational; 
format short e; 
% format long e; 
Mk
display_Mk(Mk,N,iv,v);
if nargin < 6, fi = 'float'; end; % real ranking function
if nargin < 7, radius = inf; end;  % no rigid feasibility radius
if nargin < 8, solver = 'lmilab'; end; % default solver
n = (size(Mk,1)-1)/2; % number of program variables
% N is the number of inequality constraints
M = size(Mk,3) - N; % number of inequality constraints
M0 = [X(1:n,1:n) zeros(n,n) X(1:n,n+1);
      zeros(n,n) zeros(n,n) zeros(n,1);
      X(n+1,1:n) zeros(1,n) X(n+1,n+1)];
M_0 = [zeros(n,n) zeros(n,n+1);
       zeros(n+1,n) X];
delta = [zeros(2*n,2*n) zeros(2*n,1);
         zeros(1,2*n) 1];
l0 = sdpvar(N+M,1); % Unknown Lagrange multipliers for r(x) >= 0;
L0 = set([]);    % Nonnegativity of Lagrange multipliers for inequality
for k = 1:1:N % constraints; 
 L0 = L0+set(sprintf('l0(%i,1)>0',k));
end;
CP='M0'; % Lagrangian for constraint r(x) >= 0;
for k = 1:1:N+M
  CP = strcat(CP, sprintf('-l0(%i,1)*Mk(:,:,%i)',k,k));
end;
CP = strcat(CP,'>0'); P = set(CP);
l = sdpvar(N+M,1); % Lagrange multipliers for r(x) - r(x') >= 1;
L = set([]);    % Nonnegativity of unknown Lagrange multipliers 
for k = 1:1:N  % for inequality constraints;
 L = L+set(sprintf('l(%i,1)>0',k));
end;
CD = 'M0-M_0-delta'; % Lagrangian for constraint r(x) - r(x') >= 1
for k = 1:1:N+M
  CD = strcat(CD, sprintf('-l(%i,1)*Mk(:,:,%i)',k,k));
end;
CD = strcat(CD,'>0'); D = set(CD);
F = P+D+L+L; % Gather all constraints;
[diagnostic,R] = solveconstraints(F, X, fi, radius, solver);
disp(' '); disp(diagnostic);
R
if fi(1:3) == 'int';
   intrank (R, v)
else
   fltrank (R, v) 
end
disp(' '); disp('Lagrange multipliers for constraint r(x) >= 0:');
for k = 1:1:N+M % constraints; 
 disp(sprintf('   l(%i,1) = %+e',k, double(l(k,1))));
end;
disp('Lagrange multipliers for constraint r(x) - r(x'') >= 1:');
for k = 1:1:N+M % constraints; 
 disp(sprintf('   l(%i,1) = %+e',k, double(l(k,1))));
end;

%******************************************************************************
% Copyright 2004  Patrick.Cousot@ens.fr
%******************************************************************************
% Permission to use, copy, modify, and distribute this software and its
% documentation for any purpose and without fee is hereby granted,
% provided that the above copyright notice appear in all copies and that
% both that the copyright notice and warranty disclaimer appear in
% supporting documentation.
% 
% P. Cousot disclaims all warranties with regard to this software,
% including all implied warranties of merchantability and fitness.  In
% no event shall P. Cousot be liable for any special, indirect or
% consequential damages or any damages whatsoever resulting from loss of
% use, data or profits, whether in an action of contract, negligence or
% other tortuous action, arising out of or in connection with the use or
% performance of this software.
%******************************************************************************
