function X = arw(x,blk)
% ARW computes the block diagonal arrow matrix associated
%     with the block vector x; thus each block of X is the arrow
%     matrix of the corresponding block of x, where the arrow
%     matrix of a vector (u0,u1,...,un) is
%
%        [ x0 x1 x2 ... xn ]
%        [ x1 x0  0 ...  0 ]
%        [ x2  0 x0 ...  0 ]
%        [      ...        ]
%        [ xn  0  0 ... x0 ]
%
% X = arw(x,blk)
%
%  input variables
%     - x         a block vector
%     - blk       block structure of x
%
%  output variables
%     - X         the block diagonal matrix of arrow matrices

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 5/30/97
%
 n = length(x);
 nblk = length(blk);
 X = sparse(n,n);
 fin = 0;
 for i = 1:nblk
    start = fin + 1;
    fin = fin + blk(i);
    X(start+1:fin,start) = x(start+1:fin);
 end
 X = X + X';
 X = spdiags(x,0,X);    % set diagonal of X to x
%
% END function