function [dist,v] = qcpos(x,blk)
% QCPOS checks that x lies in the (product of) Lorentz cone(s)
%
%  [dist,v] = qcpos(x,blk)
%
% input variables:
%     - x            a vector with block structure blk
%     - blk          block info structure
%
% output variables:
%     - dist         min entry of the vector of squared quadratic norms
%     - v            the vector of squared quadratic norms of the blocks
%
%  Note: if nargout = 1 the routine returns with dist = 0 as soon as it
%        encounters a block lying outiside the Lorentz cone;
%        if nargout = 2, every block is checked.

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified : 5/23/97
%
 nblk = length(blk);
 v = zeros(nblk,1);
 fin = 0;
 for i = 1:nblk
    start = fin + 1;
    fin = fin + blk(i);
    x1 = x(start);
    xtmp = x(start+1:fin);
    v(i) = x1*x1 - xtmp'*xtmp;
    if v(i) <= 0 & nargout == 1
       dist = v(i);
       return
    end
 end
 dist= min(v);
%
% END function
