function M = QCSchur(A,AAT,x,z,blk)
% QCSCHUR  forms the Schur complement for the QCQP system
%
% M = QCSchur(A,x,z,blk)
%
% Single block:
%  M = { A*A'*(x0/z0) + [(A*e0)*(A*xbar)' + (A*xbar)*(A*e0)']*1/z0
%       + (A*e0)*(A*eo)'*[(x0*zbar'*zbar)/alpha*z0 - zbar'*xbar/alpha]
%       - [(A*e0)*(A*zbar)' + (A*zbar)*(A*e0)']*x0/alpha
%       + (A*zbar)*(A*zbar)'*x0/alpha*z0 }            % symmetric
%      +
%      {+ (A*e0)*(A*xbar)'*(zbar'*zbar/alpha*z0)      % nonsymmetric
%       + (A*zbar)*(A*e0)'*(zbar'*xbar)/alpha*z0)
%       - (A*zbar)*(A*xbar)'*1/alpha }
%
% input variables:
%     - A         the constraint matrix
%     - x         the primal variable
%     - z         the dual slack
%     - blk       block structure vector
%
% output variables:
%     - M         the Schur complement

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified : 4/20/97
%
 m = size(A,1);
 M = zeros(m,m);
 fin = 0;
 fin2 = 0;
 for i = 1:length(blk)
    bsize = blk(i);
    start = fin + 1;
    start2 = fin2 + 1;
    fin = fin + bsize;
    fin2 = fin2 + m;
    xbar = x(start:fin);      % ith block of x
    x1 = xbar(1);
    xbar(1) = 0;              % xbar = bar of the ith block of x
    zbar = z(start:fin);      % ith block of z
    z1 = zbar(1);
    zbar(1) = 0;              % bar of the ith block of z
    t1 = zbar'*zbar;
    t2 = zbar'*xbar;
    alpha = z1*z1 - t1;       % quadratic norm of the dual slack z
    Ai = A(:,start:fin);      % ith block of the primal constraints
    Ae =Ai(:,1);
    Axbar = Ai*xbar;
    Azbar = Ai*zbar;
    M = M + AAT(:,start2:fin2)*x1/z1;
    tmp = Ae*Axbar';
    M = M + ((1+t1/alpha)*tmp + tmp')/z1;
    M = M + Ae*Ae'*(t1*x1/z1 - t2)/alpha;
    tmp = Ae*Azbar';
    M = M - (x1*tmp - tmp'*(t2/z1 - x1))/alpha;
    tmp = Azbar*Axbar' - Azbar*Azbar'*x1/z1;
    M = M - tmp/alpha;
 end
%
% END function
