function A = randsym(n);
% RANDSYM   generate a random symmetric nxn matrix with entries
%           uniformly distributed in the interval [-1,1)
%
% A = randsym(n)
%
% input variables:
%  - n            the size of the matrix
%
% output variables:
%  - A            a random symmetric nxn matrix

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 6/12/97
%
 A = 2*tril(rand(n,n),-1) - tril(ones(n,n),-1);
 A = A + A';
 A = A + diag(2*rand(n,1)-1);
%
% END function
