% SQLRND  generates sql problems with strictly feasible primal
%         and dual points, i.e. satisfying the Slater conditions.
%
% The following variables must be available in the Matlab workspace:
%     - blk          structure of block info
%     -     blk.s    SDP block structure
%     -     blk.q    QC block structure
%     -     blk.l    LP block structure
%     - m            number of constraints
%
% Note:  if nblk > 1 then we assume that all the blocks are nonempty,
%        i.e. that blk(i) > 0 for 1 <= i <= nblk; if nblk == 1, then
%        we allow blk(1) = 0 to siginify that the problem to be
%        constructed does not contain the corresponding type of
%        variable. In this case the corresponding A, C, X, Z are
%        simply set to zero

% SDPPACK Version 0.9 BETA
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 4/18/97
%
 if isfield(blk,'s')
    nblk.s = length(blk.s);
    sumblk.s = sum(blk.s);
    n2 = (sum(blk.s .* (blk.s+1)))/2;
 else
    nblk.s = 0;
    sumblk.s = 0;
    n2 = 0;
 end
 if isfield(blk,'q')
    nblk.q = length(blk.q);
    sumblk.q = sum(blk.q);
 else
    nblk.q = 0;
    sumblk.q = 0;
 end
 if isfield(blk,'l')
    nblk.l = 1;
    sumblk.l = sum(blk.l);
 else
    nblk.l = 0;
    sumblk.l = 0;
 end
 t = n2 + sumblk.q + sumblk.l;
 if t <= 0
    error('sqlrnd: the block structure is empty.');
    return
 end
 if m > t
    fprintf('sqlrnd: This block structure allows a maximum of %d constraints.\n', t);
    fprintf('sqlrnd: Constraints will be consistent, but redundant.\n');
 end;
 ytemp = 2*rand(m,1) - 1;
 b = zeros(m,1);
%
% first the sdp part
%
 if sumblk.s > 0
    A.s = zeros(m,n2);
    for i = 1:m
       A.s(i,:) = svec(brandsym(blk.s),blk.s)';  % a full vector
    end
    Ztemp.s = brandpos(blk.s);  % a sparse matrix if nblk.s > 1
    C.s = smat(A.s'*ytemp,blk.s) + Ztemp.s;
    Xtemp.s = brandpos(blk.s);
    b = b + A.s*svec(Xtemp.s,blk.s);
 end
%
% next the qp part
%
 if sumblk.q > 0
    A.q = 2*rand(m,sumblk.q) - 1;
    Xtemp.q = 2*rand(sumblk.q,1) - 1;
    Ztemp.q = 2*rand(sumblk.q,1) - 1;
    fin = 0;
    for i = 1:nblk.q
       start = fin + 1;
       fin = fin + blk.q(i);
       Xtemp.q(start) = abs(Xtemp.q(start)) + norm(Xtemp.q(start+1:fin));
       Ztemp.q(start) = abs(Ztemp.q(start)) + norm(Ztemp.q(start+1:fin));
    end
    C.q = A.q'*ytemp + Ztemp.q;
    b = b + A.q*Xtemp.q;
 end
%
% and last the lp part
%
 if sumblk.l > 0
    A.l = rand(m,sumblk.l);
    Xtemp.l = rand(sumblk.l,1);
    Ztemp.l = rand(sumblk.l,1);
    C.l = A.l'*ytemp + Ztemp.l;
    b = b + A.l*Ztemp.l;
 end
%
%
 clear Xtemp ytemp Ztemp nblk sumblk n2 t % discard these
