% SNRND    generates a random sum-of-norms problem: the "dual" is
%                   N
%          D:  min sum ||z_i||  s.t. B_i^T y + z_i = c_i, i=1,...,N
%                  i=1
%          and the "primal" is
%                   N                   N
%          P:  max sum c_i^T x_i  s.t. sum B_i x_i = 0,  ||x_i|| <= 1
%                  i=1                 i=1
%          with a strictly feasible solution, converting it to a
%          quadratically constrained quadratic program and writing it in
%          SQLP format.
%
% The following variables must be available in the Matlab workspace:
%     - d         dimension of the vectors x_i and z_i
%     - N         number of vectors x_i and z_i
%     - M         dimension of the dual variable y (number of primal constraints)
% The resulting problem in SQLP format has
%    blk.q = [d+1.....d+1] and m = N+M
%

% SDPPACK Version 0.9 Beta....
% Copyright (c) 1997 by
% F. Alizadeh, J.-P. Haeberly, M. Nayakkankuppam, M.L. Overton, S. Schmieta
% Last modified: 4/18/97
%
 blk.s = [];
 blk.l = [];
 A.s = [];
 A.l = [];
 C.s = [];
 C.l = [];
%
 blk.q = (d+1)*ones(N,1);
 sumblk = (d+1)*N;
 m = M + N;   % the norm constraint results in an extra variable
%
 if m > sumblk
    fprintf('snrnd: This block structure allows a maximum of %d constraints.\n', sumblk);
    fprintf('snrnd: Constraints will be consistent, but redundant.\n');
 end;
 b = zeros(m,1);
 b(1:N) = ones(N,1);
%
% the qp part
%
 C.q = 2*rand(sumblk,1) - 1;
 A.q = zeros(m,sumblk);
 A.q(N+1:m,:) = 2*rand(M,sumblk) - 1;
 fin = 0;
 for i = 1:N,
    start = fin + 1;
    fin = fin + blk.q(i);
    C.q(start) = 0;
    A.q(:,start) = zeros(m,1);
    A.q(i,start) = 1;
 end
%
 clear start fin
