function [f, g] = samplefun(x, pars)

% simple non-Lipschitz two variable problem for gradient sampling demo
% solution is 0, but x(2) negative does not increase f nearly as much as
% x(1) negative, or either one of them positive, so x(1) will usually be reduced 
% closer to zero and x(2) will usually end up negative rather than positive
% pars is not used here, but can be used to pass any necessary parameters
% Written by M. Overton (overton@cs.nyu.edu), last revised Feb 2005
% 

term1 = sqrt(abs(x(1)));
term2 = real(sqrt(x(2)));    % 0 if x(2) <= 0
term3 = abs(x(2));
f = term1 + term2 + term3;
% compute gradient of f
g = zeros(2,1);  % must be a column vector, not row
% first gradient of term1: 3 cases
if x(1) > 0      
   g(1) = 0.5/term1;
elseif x(2) < 0  % if exactly 0, gradient not defined, could use any finite value
   g(1) = -0.5/term1;
end
% now gradients of term2 and term3: two cases
if x(2) > 0      
   g(2) = 0.5/term2 + 1;
else  % elseif also OK: if exactly 0, gradient not defined, could use any number >= -1
   g(2) = -1;
end
   