function smaller = fcomparedefault(x, f0, pars)
%  default function to check whether the function
%  at a candidate new point is reduced below the previous value, instead
%  of actually computing the new value.  The idea is that in some cases,
%  such as pseudospectral functions, it's much cheaper to make this check.
%  However, in other cases it is not, and if the user does not provide such
%  a function, this routine is called instead, computing the new function and
%  making the comparison
%  Written by M. Overton (overton@cs.nyu.edu), last revised March 2003

f = feval(pars.fgname, x, pars);   % gradient not needed
if f < f0 
   smaller = 1;
else
   smaller = 0;
end
