package csci102_generic_linked_list;

public class MySortedList <T  extends Comparable <T> > {

	private int theSize;
	private Node<T> first;

	public MySortedList(){
		theSize = 0;
		first = null; 
	}

	public void add(T x)
	{ 
		//if the list is empty or x belongs at the beginning 
		if (first == null || first.data.compareTo(x) > 0 )
		{
			first = new Node<T>(x,first); 
			theSize++;
		}
		//otherwise we need to find the right place
		else 
		{
			Node<T> current = first;
			while (current.next != null  && current.next.data.compareTo(x) < 0 )
			{
				current = current.next;
			}
			Node <T> c = new Node<T>(x,current.next); 
			current.next = c;
		}
	}

	public void remove(T x){
		if (first == null) return;

		Node<T> prevNode = findPrevNode(x);
		if (prevNode == null){  // x is first node on list?
			if (x.equals(first.data)) first = first.next;
		}
		else
			prevNode.next = (prevNode.next).next;
	}

	private  Node<T> findPrevNode(T x){
		Node<T> r = first;
		if (x.equals(first.data)) return  null;

		//assumes tested for r!= null above, non-null list
		while (r.next != null ){ 
			if (x.equals((r.next).data)) return r;
			r = r.next;
		}//end while
		return null;
	}

	public String toString(){
		Node<T> A = this.first;
		String S = "[";
		while (A != null){
			S = S +  A;
			A = A.next;
		}
		return S + "]";
	}



	// ------------------------------------------------------

	private class Node<S extends Comparable <S> >{

		public S data;
		public Node<S> next;

		public Node(S d,  Node<S> n){
			data = d; next = n;
		}

		public String toString(){
			return " " + this.data;
		}
	}// end class Node
	
}
