package csci102_generic_linked_list;

public class MyList<T> {

	private int theSize;
	private Node<T> first;

	public MyList(){
		theSize = 0;
		first = null; //actually this is the default
	}

	public void addFront(T x){ // always add at beginning
		first = new Node<T>(x,first); 
		theSize++;
	}

	public void remove(T x){
		if (first == null) return;

		Node<T> prevNode = findPrevNode(x);
		if (prevNode == null){  // x is first node on list?
			if (x.equals(first.data)) first = first.next;
		}
		else
			prevNode.next = (prevNode.next).next;
	}

	private  Node<T> findPrevNode(T x){
		Node<T> r = first;
		if (x.equals(first.data)) return  null;

		//assumes tested for r!= null above, non-null list
		while (r.next != null ){ 
			if (x.equals((r.next).data)) return r;
			r = r.next;
		}//end while
		return null;
	}

	public String toString(){
		Node<T> A = this.first;
		String S = "[";
		while (A != null){
			S = S +  A;
			A = A.next;
		}
		return S + "]";
	}



	// ------------------------------------------------------

	private class Node<S>{

		public S data;
		public Node<S> next;

		public Node(S d,  Node<S> n){
			data = d; next = n;
		}

		public String toString(){
			return " " + this.data;
		}
	}// end class Node

}// end MyList
