//package csci102_hashing;

import java.util.Scanner;

public class MyHashTable {

	private static int DefaultSize = 10;
	private int numFilled;
	private static int numOfCollisions;

	private MyNode[] table;

	public String toString() {
		String rval = "";
		for (int i = 0; i < table.length; i++) {
			MyNode N = table[i];
			rval = rval + i + ": " + N + "\n";
		}
		return rval;
	}

	public MyHashTable(int size) { // Constructor
		table = new MyNode[size];
		numFilled = 0;
		numOfCollisions = 0;
	}

	public MyHashTable() {
		this(DefaultSize);
	} // Default constructor

	// Hashes string S to a value between 0 and L-1;

	public int MyHash(String S) {		
		int num = 0;
		
		for (int i = 0; i < S.length(); i++ )
		{
			num = 37*num + (int) S.charAt(i);
		}	
		
		double goldenRatio = 0.6180339887;
		double fractionalKey = num * goldenRatio 
		           - Math.floor(num * goldenRatio);
		num = (int) Math.floor( table.length * fractionalKey );
		
		return num;

	}
	// Find node for Key at Index

	private MyNode FindNode(String Key, int Index) {
		for (int i = 0; i < table.length; i++) {
			int effectiveIdx = ((Index + i) % table.length);
			MyNode N = table[effectiveIdx];
			if (N == null)
				return null;
			if (N.key == Key && !N.deleted)
				return N;
		}
		// searched the entire list, didn't find it
		return null;
	}

	// Add Student PP under key Key

	public boolean put(String Key, Student PP) {
		int Index = MyHash(Key);
		// Note: A previous version of this code had a bug
		MyNode N = FindNode(Key, Index);
		//if node is found, just change its value
		if (N != null) {
			N.value = PP;
			return true;
		} 
		//otherwise add the node
		else {
			numFilled++;
			for (int i = 0; i < table.length; i++) {
				int effectiveIdx = ((Index + i) % table.length);
				N = table[effectiveIdx];
				if (N == null) {
					if (i > 0 )		numOfCollisions++;
					table[effectiveIdx] = new MyNode(Key, PP);
					return true;
				} else if (N.deleted) {
					if (i > 0 ) 	numOfCollisions++;
					N.key = Key;
					N.value = PP;
					N.deleted = false;
					return true;
				} else if (N.key == Key) {
					System.out.println("This should never happen!");
					N.value = PP;
					return true;
				}
			}
			return false;
		}
	}

	public boolean remove(String Key) {
		int Index = MyHash(Key);
		MyNode N = FindNode(Key, Index);
		if (N != null) {
			N.deleted = true;
			return true;
		} else {
			return false;
		}
	}

	// Locate the Student object under string Key
	public Student get(String Key) {
		int Index = MyHash(Key);
		MyNode N = FindNode(Key, Index);
		if (N == null)
			return null;
		else
			return N.value;
	}

	public static void main(String[] args) {
		MyHashTable t = new MyHashTable( 311 );
		// System.out.print(t);
		Scanner in = new Scanner(System.in);
		String line;
		String [] studentData = new String [2];
		
		for(int i = 0; i < 154; i++)
		{
			line = in.nextLine();
			studentData = line.split("\t");
			
			t.put(studentData[0], new Student(studentData[1]) ) ;
		}
		System.out.println("Number of detected collisions: " + MyHashTable.numOfCollisions );
		
		in.close();
	}

}
