//add doesn't add

// ***********************************************************************
//
// Broken10 Class Interface
//
// ***********************************************************************
// Computer Science 102: Data Structures
// New York University, Fall 2013,
//
// Lecturers: Eric Koskinen and Daniel Schwartz-Narbonne
//
// ***********************************************************************

import java.lang.*;

public class Broken10 implements Set {
    protected String value;
    protected Broken10 next;

    public Broken10(String v, Broken10 n) {
	value = v;
	next = n;
    }

    public Broken10(String v) {
	value = v;
	next = null;
    }
    
    public String getValue() {
	return value;
    }
	
    public Broken10 getNext() {
	return next;
    }
	
    // Basic operations
    public int size() {
	if(next == null) {
	    //Base case, list with one element
	    return 1;
	} else {
	    //recursive case
	    return 1 + next.size();
	}
    }
    
    public String min() {
	//the head is the smallest node on a sorted list
	//so just return our own value
	return value;
    }

    public String max() {
	if(next == null){
	    //base case, last (largest) element on the list
	    return value;
	} else {
	    //recurse to find the largest element
	    return next.max();
	}
    }

    public boolean isEmpty() {
	//there is at least one node, i.e. the one we are currently visiting
	return false;
    }

    public boolean contains(String el) {
	if(el == null){
	    return false; //null strings cannot be in the set
	} 
	int c = value.compareTo(el);
	if (c == 0){ // value == el
	    //we found it
	    return true;
	} else if(c > 0){ // value > el
	    //our current node is already greater than the target
	    //the target is not in the list
	    return false;
	} else { //current node is smaller than the target
	    if (next == null) {
		//at the end of the list, so node not on list
		return false;
	    } else {
		return next.contains(el);
	    }
	}
    }
	

    public boolean add(String el) {
	return !contains(el);
    }

    public boolean remove(String element)  {
	//Sanitize our inputs
	if(element == null) {
	    return false;
	}

	//find the node we want to remove after
	//there is an invarient that value != element
	int c = element.compareTo(value);
	if (c < 0) {
	    //element is less than the current node value
	    //hence element doesnt appear within the list
	    //or else we would have found it by now
	    return false;
	} else { //element is greater than the current node
	    if(next == null){
		//list ends, without finding element
		return false;
	    } else if (next.getValue().equals(element)) {
		//we found the node to remove
		next = next.getNext();
		return true;
	    } else { 
		//recursive case
		return next.remove(element);
	    }
	}
    }

    public String toString() {
	if (next  == null) {
	    return  " \"" + value + "\" ";
	} else {
	    return  " \"" + value + "\" ;" + next.toString();
	}   
    }
	
    public void PrettyPrint() {
	System.out.println(this.toString());
    }
}
