/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Lisp.Variable;
import Jet.Pat.PatternApplication;
import Jet.Pat.PatternSyntaxError;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.Vector;

public class StringExpression {
    Vector elements = new Vector();

    public StringExpression(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        while (true) {
            String string;
            if (streamTokenizer.ttype == 34) {
                string = streamTokenizer.sval;
                this.elements.addElement(string);
            } else if (streamTokenizer.ttype == -3 && Character.isUpperCase(streamTokenizer.sval.charAt(0))) {
                string = streamTokenizer.sval;
                this.elements.addElement(new Variable(string));
            } else {
                throw new PatternSyntaxError("invalid print/write expression");
            }
            if (streamTokenizer.nextToken() != 43) {
                return;
            }
            streamTokenizer.nextToken();
        }
    }

    public String evaluate(Document document, PatternApplication patternApplication) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.elements.size(); ++i) {
            Object e = this.elements.elementAt(i);
            if (e instanceof String) {
                stringBuffer.append((String)e);
                continue;
            }
            if (e instanceof Variable) {
                Object object;
                Variable variable = (Variable)e;
                HashMap hashMap = patternApplication.bestBindings;
                Object v = hashMap.get(variable.name);
                if (v instanceof Span) {
                    object = (Span)v;
                    stringBuffer.append(this.cleanWhitespace(document.text((Span)object)));
                    continue;
                }
                if (v instanceof Annotation) {
                    object = (Annotation)v;
                    stringBuffer.append(this.cleanWhitespace(document.text((Annotation)object)));
                    continue;
                }
                stringBuffer.append(" ? ");
                continue;
            }
            throw new Error("invalid element in StringExpression");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.elements.size(); ++i) {
            Object e;
            if (i > 0) {
                stringBuffer.append(" + ");
            }
            if ((e = this.elements.elementAt(i)) instanceof String) {
                stringBuffer.append("\"" + (String)e + "\"");
                continue;
            }
            if (e instanceof Variable) {
                Variable variable = (Variable)e;
                stringBuffer.append(variable.toString());
                continue;
            }
            throw new Error("invalid element in StringExpression");
        }
        return stringBuffer.toString();
    }

    private String cleanWhitespace(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (!Character.isWhitespace(stringBuffer.charAt(i))) continue;
            stringBuffer.setCharAt(i, ' ');
        }
        return stringBuffer.toString();
    }
}

