/*
 * Decompiled with CFR 0.152.
 */
package Jet.Pat;

import Jet.Console;
import Jet.Lisp.FeatureSet;
import Jet.Lisp.Variable;
import Jet.Pat.Action;
import Jet.Pat.Pat;
import Jet.Pat.PatternApplication;
import Jet.Pat.PatternSyntaxError;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.util.HashMap;

public class AddFeaturesAction
extends Action {
    FeatureSet features;
    Variable annotationVariable;

    public AddFeaturesAction(FeatureSet featureSet, Variable variable) {
        this.features = featureSet;
        this.annotationVariable = variable;
    }

    public AddFeaturesAction(StreamTokenizer streamTokenizer) throws IOException, PatternSyntaxError {
        if (streamTokenizer.nextToken() != 91) {
            throw new PatternSyntaxError("[ expected");
        }
        this.features = new FeatureSet(streamTokenizer, true, ']');
        if (streamTokenizer.nextToken() == -3 && streamTokenizer.sval.equalsIgnoreCase("to")) {
            if (streamTokenizer.nextToken() != -3 || !Character.isUpperCase(streamTokenizer.sval.charAt(0))) {
                throw new PatternSyntaxError("variable expected after 'to'");
            }
        } else {
            throw new PatternSyntaxError("'to' expected");
        }
        this.annotationVariable = new Variable(streamTokenizer.sval);
        streamTokenizer.nextToken();
    }

    public int perform(Document document, PatternApplication patternApplication) {
        HashMap hashMap = patternApplication.bestBindings;
        Object v = hashMap.get(this.annotationVariable.name);
        if (!(v instanceof Annotation)) {
            System.out.println("Value of " + this.annotationVariable.toString() + " is not an annotation");
            return -1;
        }
        Annotation annotation = (Annotation)v;
        FeatureSet featureSet = this.features.substitute(hashMap);
        if (Pat.trace) {
            Console.println("Adding features " + featureSet.toSGMLString() + " to " + annotation);
        }
        annotation.attributes().putAll(featureSet);
        return annotation.span().end();
    }

    public String toString() {
        return "addFeatures [" + this.features.toSGMLString() + "] to " + this.annotationVariable.toString();
    }
}

