/*
 * Decompiled with CFR 0.152.
 */
package Jet.Lex;

import Jet.Lex.LexicalEntry;
import Jet.Lisp.FeatureSet;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.util.Hashtable;
import java.util.Vector;

public class Lexicon {
    static Hashtable lexiconIndex = new Hashtable();

    public static void clear() {
        lexiconIndex.clear();
    }

    public static boolean clearEntry(String[] stringArray) {
        String string = stringArray[0].toLowerCase();
        if (lexiconIndex.containsKey(string)) {
            Vector vector = (Vector)lexiconIndex.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                LexicalEntry lexicalEntry = (LexicalEntry)vector.get(i);
                if (!lexicalEntry.matches(stringArray)) continue;
                vector.remove(i);
                return true;
            }
        }
        return false;
    }

    public static void addEntry(String[] stringArray, FeatureSet featureSet) {
        String string = stringArray[0].toLowerCase();
        if (lexiconIndex.containsKey(string)) {
            Vector vector = (Vector)lexiconIndex.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                LexicalEntry lexicalEntry = (LexicalEntry)vector.get(i);
                if (!lexicalEntry.matches(stringArray)) continue;
                lexicalEntry.addDefinition(featureSet);
                return;
            }
            vector.addElement(new LexicalEntry(stringArray, featureSet));
        } else {
            Vector<LexicalEntry> vector = new Vector<LexicalEntry>();
            vector.addElement(new LexicalEntry(stringArray, featureSet));
            lexiconIndex.put(string, vector);
        }
    }

    public static FeatureSet[] lookUp(String[] stringArray) {
        String string = stringArray[0].toLowerCase();
        if (lexiconIndex.containsKey(string)) {
            Vector vector = (Vector)lexiconIndex.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                LexicalEntry lexicalEntry = (LexicalEntry)vector.get(i);
                if (!lexicalEntry.matches(stringArray)) continue;
                return lexicalEntry.getDefinition();
            }
        }
        return null;
    }

    public static int annotateWithDefinitions(Document document, int n) {
        int n2 = 0;
        FeatureSet[] featureSetArray = null;
        Annotation annotation = document.tokenAt(n);
        if (annotation == null) {
            return 0;
        }
        String string = document.text(annotation).trim().toLowerCase();
        if (lexiconIndex.containsKey(string)) {
            Vector vector = (Vector)lexiconIndex.get(string);
            for (int i = 0; i < vector.size(); ++i) {
                LexicalEntry lexicalEntry = (LexicalEntry)vector.get(i);
                int n3 = lexicalEntry.matches(document, n);
                if (n3 <= 0 || n3 <= n2) continue;
                n2 = n3;
                featureSetArray = lexicalEntry.getDefinition();
            }
        }
        if (featureSetArray != null) {
            for (int i = 0; i < featureSetArray.length; ++i) {
                document.annotate("constit", new Span(n, n2), new FeatureSet((FeatureSet)featureSetArray[i]));
            }
        }
        return n2;
    }

    public static void annotateWithDefinitions(Document document, int n, int n2) {
        int n3 = n;
        while (document.tokenAt(n3) == null) {
            if (++n3 < n2) continue;
            return;
        }
        while (n3 < n2) {
            int n4 = Lexicon.annotateWithDefinitions(document, n3);
            if (n4 == 0) {
                Annotation annotation = document.tokenAt(n3);
                if (annotation == null) {
                    return;
                }
                n3 = annotation.span().end();
                continue;
            }
            n3 = n4;
        }
    }
}

