/*
 * Decompiled with CFR 0.152.
 */
package Jet.HMM;

import AceJet.Ace;
import Jet.Console;
import Jet.HMM.BigramHMMemitter;
import Jet.HMM.HMM;
import Jet.HMM.HMMannotator;
import Jet.HMM.HMMstate;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Scorer.SGMLScorer;
import Jet.Tipster.Annotation;
import Jet.Tipster.AnnotationColor;
import Jet.Tipster.Document;
import Jet.Tipster.DocumentCollection;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import Jet.Zoner.SentenceSplitter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class HMMNameTagger {
    public HMM nameHMM;
    public HMMannotator annotator;
    String[][] tagTable;
    String[] NEtypeTable;
    String[] tagsToRead;
    String[] tagsToCache;
    String[] tagsToScore;
    Class emitterClass;
    static final String home = "C:/Documents and Settings/Ralph Grishman/My Documents/";
    static final boolean useAceBigrams = false;
    static /* synthetic */ Class class$Jet$HMM$HMMemitter;
    static /* synthetic */ Class class$Jet$HMM$WordFeatureHMMemitter;

    public HMMNameTagger(Class clazz) {
        if (!(class$Jet$HMM$HMMemitter == null ? (class$Jet$HMM$HMMemitter = HMMNameTagger.class$("Jet.HMM.HMMemitter")) : class$Jet$HMM$HMMemitter).isAssignableFrom(clazz)) {
            System.out.println("HMMNameTagger constructor invoked with invalid class " + clazz);
            return;
        }
        this.emitterClass = clazz;
        this.nameHMM = new HMM(clazz);
        this.annotator = new HMMannotator(this.nameHMM);
        this.annotator.setBItag(false);
        this.annotator.setAnnotateEachToken(false);
    }

    private void readTagTable(String string) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            this.readTagTable(bufferedReader);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void readTagTable(BufferedReader bufferedReader) {
        this.annotator.readTagTable(bufferedReader);
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        String[][] stringArray = this.annotator.getTagTable();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.add(stringArray[i][0]);
            arrayList.add(stringArray[i][3]);
        }
        this.NEtypeTable = arrayList.toArray(new String[0]);
        this.tagsToCache = this.NEtypeTable;
        this.nameHMM.setTagsToCache(this.tagsToCache);
        this.tagsToScore = hashSet.toArray(new String[0]);
        hashSet.add("SENT");
        hashSet.add("TURN");
        this.tagsToRead = hashSet.toArray(new String[0]);
    }

    private void writeTagTable(PrintWriter printWriter) {
        this.annotator.writeTagTable(printWriter);
    }

    void buildNameHMM(String string) {
        this.readTagTable(string);
        HMMstate hMMstate = new HMMstate("start", "", this.emitterClass);
        this.nameHMM.addState(hMMstate);
        hMMstate.addArc("other");
        hMMstate.addArc("end");
        for (int i = 0; i < this.NEtypeTable.length; ++i) {
            hMMstate.addArc("pre-" + this.NEtypeTable[i]);
            hMMstate.addArc("i-" + this.NEtypeTable[i]);
            hMMstate.addArc("b-" + this.NEtypeTable[i]);
        }
        HMMstate hMMstate2 = new HMMstate("other", "other", this.emitterClass);
        this.nameHMM.addState(hMMstate2);
        hMMstate2.addArc("other");
        hMMstate2.addArc("end");
        for (int i = 0; i < this.NEtypeTable.length; ++i) {
            hMMstate2.addArc("pre-" + this.NEtypeTable[i]);
        }
        HMMstate hMMstate3 = new HMMstate("end", "", this.emitterClass);
        this.nameHMM.addState(hMMstate3);
        for (int i = 0; i < this.NEtypeTable.length; ++i) {
            String string2 = this.NEtypeTable[i];
            HMMstate hMMstate4 = new HMMstate("pre-" + string2, "other", this.emitterClass);
            this.nameHMM.addState(hMMstate4);
            hMMstate4.addArc("i-" + string2);
            hMMstate4.addArc("b-" + string2);
            HMMstate hMMstate5 = new HMMstate("i-" + string2, string2, this.emitterClass);
            this.nameHMM.addState(hMMstate5);
            HMMstate hMMstate6 = new HMMstate("b-" + string2, string2, this.emitterClass);
            this.nameHMM.addState(hMMstate6);
            hMMstate6.addArc("m-" + string2);
            hMMstate6.addArc("e-" + string2);
            HMMstate hMMstate7 = new HMMstate("m-" + string2, string2, this.emitterClass);
            this.nameHMM.addState(hMMstate7);
            hMMstate7.addArc("m-" + string2);
            hMMstate7.addArc("e-" + string2);
            HMMstate hMMstate8 = new HMMstate("e-" + string2, string2, this.emitterClass);
            this.nameHMM.addState(hMMstate8);
            HMMstate hMMstate9 = new HMMstate("post-" + string2, "other", this.emitterClass);
            this.nameHMM.addState(hMMstate9);
            for (int j = 0; j < this.NEtypeTable.length; ++j) {
                hMMstate5.addArc("pre-" + this.NEtypeTable[j]);
                hMMstate8.addArc("pre-" + this.NEtypeTable[j]);
                hMMstate9.addArc("pre-" + this.NEtypeTable[j]);
                if (i == j) continue;
                hMMstate5.addArc("i-" + this.NEtypeTable[j]);
                hMMstate5.addArc("b-" + this.NEtypeTable[j]);
                hMMstate8.addArc("i-" + this.NEtypeTable[j]);
                hMMstate8.addArc("b-" + this.NEtypeTable[j]);
            }
            hMMstate5.addArc("post-" + string2);
            hMMstate5.addArc("end");
            hMMstate8.addArc("post-" + string2);
            hMMstate8.addArc("end");
            hMMstate9.addArc("other");
            hMMstate9.addArc("end");
        }
        this.nameHMM.resolveNames();
        this.nameHMM.resetForTraining();
    }

    public void train(String string) throws IOException {
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        for (int i = 0; i < documentCollection.size(); ++i) {
            Object object;
            Object object2;
            ExternalDocument externalDocument = documentCollection.get(i);
            externalDocument.setSGMLtags(this.tagsToRead);
            externalDocument.open();
            System.out.println("Training from " + externalDocument.fileName());
            externalDocument.annotateWithTag("TEXT");
            this.nameHMM.newDocument();
            Vector vector = externalDocument.annotationsOfType("TEXT");
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                object2 = (Annotation)iterator.next();
                object = ((Annotation)object2).span();
                Ace.monocase = Ace.allLowerCase(externalDocument);
                System.out.println(">>> Monocase is " + Ace.monocase);
                SentenceSplitter.split(externalDocument, (Span)object);
            }
            object2 = externalDocument.annotationsOfType("sentence");
            if (object2 == null) continue;
            object = ((Vector)object2).iterator();
            while (object.hasNext()) {
                Annotation annotation = (Annotation)object.next();
                Span span = annotation.span();
                Tokenizer.tokenize(externalDocument, span);
                this.annotator.trainOnSpan(externalDocument, span);
            }
            externalDocument.clearAnnotations();
        }
        this.nameHMM.computeProbabilities();
    }

    public void store(String string) throws IOException {
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), JetTest.encoding)));
        this.writeTagTable(printWriter);
        printWriter.println("endtags");
        this.nameHMM.store(printWriter);
    }

    public void load(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), JetTest.encoding));
        this.readTagTable(bufferedReader);
        this.nameHMM.load(bufferedReader);
    }

    private void tagDocument(Document document) {
        Object object;
        Object object2;
        document.annotateWithTag("TEXT");
        Vector vector = document.annotationsOfType("TEXT");
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            object2 = (Annotation)iterator.next();
            object = ((Annotation)object2).span();
            Ace.monocase = Ace.allLowerCase(document);
            System.out.println(">>> Monocase is " + Ace.monocase);
            SentenceSplitter.split(document, (Span)object);
        }
        object2 = document.annotationsOfType("sentence");
        object = ((Vector)object2).iterator();
        while (object.hasNext()) {
            Annotation annotation = (Annotation)object.next();
            Span span = annotation.span();
            Tokenizer.tokenize(document, span);
            this.tag(document, span);
        }
    }

    public void tag(Document document, Span span) {
        this.annotator.annotateSpan(document, span);
    }

    public void scoreCollection(String string, String string2) {
        DocumentCollection documentCollection = new DocumentCollection(string);
        documentCollection.open();
        DocumentCollection documentCollection2 = new DocumentCollection(string2);
        documentCollection2.open();
        if (documentCollection.size() != documentCollection2.size()) {
            System.out.println(" ** Test and key collections have different sizes, cannot evaluate.");
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < documentCollection.size(); ++i) {
            ExternalDocument externalDocument = documentCollection.get(i);
            externalDocument.setSGMLtags(this.tagsToRead);
            externalDocument.open();
            this.nameHMM.newDocument();
            System.out.println("Annotating document " + i + ": " + externalDocument.fileName());
            this.tagDocument(externalDocument);
            ExternalDocument externalDocument2 = documentCollection2.get(i);
            externalDocument2.setSGMLtags(this.tagsToRead);
            externalDocument2.open();
            externalDocument2.annotateWithTag("text");
            Span span = ((Annotation)externalDocument2.annotationsOfType("text").get(0)).span();
            HMMNameTagger.eraseAnnotationsOutside(externalDocument2, "ENAMEX", span);
            HMMNameTagger.eraseAnnotationsOutside(externalDocument2, "TIMEX", span);
            HMMNameTagger.eraseAnnotationsOutside(externalDocument2, "NUMEX", span);
            SGMLScorer sGMLScorer = new SGMLScorer(externalDocument, externalDocument2);
            for (int j = 0; j < this.tagsToScore.length; ++j) {
                sGMLScorer.match(this.tagsToScore[j]);
                Console.println(sGMLScorer.report());
            }
            System.out.println("Total tags in response:  " + sGMLScorer.totalTagsInDoc1);
            System.out.println("Total tags in key:       " + sGMLScorer.totalTagsInDoc2);
            System.out.println("Matching tags:           " + sGMLScorer.totalMatchingTags);
            System.out.println("Matching attributes:     " + sGMLScorer.totalMatchingAttrs);
            System.out.println("Type recall:             " + (float)sGMLScorer.totalMatchingTags / (float)sGMLScorer.totalTagsInDoc2);
            System.out.println("Type precision:          " + (float)sGMLScorer.totalMatchingTags / (float)sGMLScorer.totalTagsInDoc1);
            System.out.println("Attribute recall:        " + (float)sGMLScorer.totalMatchingAttrs / (float)sGMLScorer.totalTagsInDoc2);
            System.out.println("Attribute precision:     " + (float)sGMLScorer.totalMatchingAttrs / (float)sGMLScorer.totalTagsInDoc1);
            n += sGMLScorer.totalTagsInDoc1;
            n2 += sGMLScorer.totalTagsInDoc2;
            n3 += sGMLScorer.totalMatchingTags;
            n4 += sGMLScorer.totalMatchingAttrs;
        }
        System.out.println("Overall Type Recall:          " + (float)n3 / (float)n2);
        System.out.println("Overall Type Precision:       " + (float)n3 / (float)n);
        System.out.println("Overall Attribute Recall:     " + (float)n4 / (float)n2);
        System.out.println("Overall Attribute Precision:  " + (float)n4 / (float)n);
    }

    private static void eraseAnnotationsOutside(Document document, String string, Span span) {
        Vector vector = document.annotationsOfType(string);
        if (vector == null) {
            return;
        }
        vector = (Vector)vector.clone();
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            if (annotation.span().within(span)) continue;
            document.removeAnnotation(annotation);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        new AnnotationColor("C:/Documents and Settings/Ralph Grishman/My Documents/HMM");
        HMMNameTagger.mucLoadTest();
    }

    static void aceTrainTest() throws IOException {
        HMMNameTagger hMMNameTagger = new HMMNameTagger(class$Jet$HMM$WordFeatureHMMemitter == null ? (class$Jet$HMM$WordFeatureHMMemitter = HMMNameTagger.class$("Jet.HMM.WordFeatureHMMemitter")) : class$Jet$HMM$WordFeatureHMMemitter);
        hMMNameTagger.buildNameHMM("acedata/ACEnameTags.txt");
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/NE/ACE BBN Collection.txt";
        String string2 = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/NE/ACE training Collection.txt";
        String string3 = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/NE/ACE aug03 Collection.txt";
        String string4 = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 nwire 21andup ne.txt";
        String string5 = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/training04 bnews 21andup ne.txt";
        hMMNameTagger.train(string);
        hMMNameTagger.train(string2);
        hMMNameTagger.train(string4);
        hMMNameTagger.train(string5);
        hMMNameTagger.store("acedata/ACEname04HMM.txt");
        HMMNameTagger.aceTest(hMMNameTagger);
    }

    private static void aceLoadTest() throws IOException {
        HMMNameTagger hMMNameTagger = new HMMNameTagger(class$Jet$HMM$WordFeatureHMMemitter == null ? (class$Jet$HMM$WordFeatureHMMemitter = HMMNameTagger.class$("Jet.HMM.WordFeatureHMMemitter")) : class$Jet$HMM$WordFeatureHMMemitter);
        hMMNameTagger.load("acedata/ACEname04HMM.txt");
        HMMNameTagger.aceTest(hMMNameTagger);
    }

    private static void aceTest(HMMNameTagger hMMNameTagger) throws IOException {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/rdreval04 nwire sgm.txt";
        String string2 = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/rdreval04 nwire ne.txt";
        BigramHMMemitter.useBigrams = false;
        hMMNameTagger.scoreCollection(string, string2);
    }

    private static void mucTrainTest() throws IOException {
        HMMNameTagger hMMNameTagger = new HMMNameTagger(class$Jet$HMM$WordFeatureHMMemitter == null ? (class$Jet$HMM$WordFeatureHMMemitter = HMMNameTagger.class$("Jet.HMM.WordFeatureHMMemitter")) : class$Jet$HMM$WordFeatureHMMemitter);
        hMMNameTagger.buildNameHMM("data/MUCnameTags.txt");
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/NE/NE train Collection.txt";
        hMMNameTagger.train(string);
        hMMNameTagger.store("data/MUCnameHMM.txt");
        HMMNameTagger.mucTest(hMMNameTagger);
    }

    private static void mucLoadTest() throws IOException {
        HMMNameTagger hMMNameTagger = new HMMNameTagger(class$Jet$HMM$WordFeatureHMMemitter == null ? (class$Jet$HMM$WordFeatureHMMemitter = HMMNameTagger.class$("Jet.HMM.WordFeatureHMMemitter")) : class$Jet$HMM$WordFeatureHMMemitter);
        hMMNameTagger.buildNameHMM("data/MUCnameTags.txt");
        hMMNameTagger.load("data/MUCnameHMM.txt");
        HMMNameTagger.mucTest(hMMNameTagger);
    }

    private static void mucTest(HMMNameTagger hMMNameTagger) throws IOException {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/NE/NE test Collection.txt";
        String string2 = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/NE/NE key Collection.txt";
        hMMNameTagger.scoreCollection(string, string2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

