/*
 * Decompiled with CFR 0.152.
 */
package Jet.Chunk;

import Jet.Console;
import Jet.JetTest;
import Jet.Lex.Tokenizer;
import Jet.Tipster.Annotation;
import Jet.Tipster.Document;
import Jet.Tipster.Span;
import java.io.File;
import java.util.Vector;
import opennlp.maxent.GISModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;

public class Chunker {
    public static GISModel model = null;
    static Annotation[] tokens;
    static int tokenCount;
    static int jetTokenCount;
    static String[] pos;
    static String[] word;
    static String[] tag;
    static int[] position;
    static boolean trace;

    public static void chunk(Document document, Span span) {
        int n;
        int n2;
        tokens = Tokenizer.gatherTokens(document, span);
        tokenCount = tokens.length;
        if (tokenCount == 0) {
            return;
        }
        pos = new String[tokenCount];
        word = new String[tokenCount];
        position = new int[tokenCount];
        int n3 = 0;
        for (n2 = 0; n2 < tokenCount; ++n2) {
            int n4;
            Chunker.position[n3] = n4 = tokens[n2].span().start();
            Chunker.pos[n3] = Chunker.getPosAt(document, n4);
            Chunker.word[n3] = document.text(tokens[n2]).trim();
            if (n3 >= 2 && document.text(tokens[n2 - 1]).equals("-")) {
                Chunker.pos[n3 - 2] = "JJ";
                Chunker.word[n3 - 2] = word[n3 - 2] + word[n3 - 1] + word[n3];
                n3 -= 2;
            }
            ++n3;
        }
        jetTokenCount = n3;
        tag = new String[jetTokenCount];
        for (n2 = 0; n2 < jetTokenCount; ++n2) {
            String[] stringArray = Chunker.chunkFeatures(n2);
            Chunker.tag[n2] = model.getBestOutcome(model.eval(stringArray)).intern();
            if (n2 != 0 && tag[n2 - 1] != "O" || tag[n2] != "B") continue;
            Chunker.tag[n2] = "I";
        }
        n2 = -1;
        int n5 = -1;
        for (n = 0; n < jetTokenCount; ++n) {
            Object object;
            int n6 = position[n];
            if (n5 == n6) {
                n5 = -1;
            }
            if (n2 >= 0 && tag[n] == "O" | tag[n] == "B" && n5 < 0) {
                object = new Annotation("ng", new Span(n2, n6), null);
                document.addAnnotation((Annotation)object);
                if (trace) {
                    Console.println("Annotate " + document.text((Annotation)object) + " as " + object);
                }
                n2 = -1;
            }
            if (n5 < 0 && (object = document.annotationsAt(n6, "ENAMEX")) != null && ((Vector)object).size() > 0) {
                Annotation annotation = (Annotation)((Vector)object).get(0);
                n5 = annotation.span().end();
            }
            if (n2 >= 0 || tag[n] != "B" && tag[n] != "I" && n5 <= 0) continue;
            n2 = n6;
        }
        if (n2 >= 0) {
            n = tokens[tokenCount - 1].span().end();
            Annotation annotation = new Annotation("ng", new Span(n2, n), null);
            document.addAnnotation(annotation);
            if (trace) {
                Console.println("Annotate " + document.text(annotation) + " as " + annotation);
            }
        }
    }

    private static String getPosAt(Document document, int n) {
        Vector vector = document.annotationsAt(n, "tagger");
        if (vector == null || vector.size() == 0) {
            return "";
        }
        Annotation annotation = (Annotation)vector.get(0);
        return (String)annotation.get("cat");
    }

    private static String[] chunkFeatures(int n) {
        String[] stringArray = new String[]{"prevPOS=" + (n > 0 ? pos[n - 1] : ""), "currPOS=" + pos[n], "nextPOS=" + (n < jetTokenCount - 1 ? pos[n + 1] : ""), n < jetTokenCount - 2 ? "POS012=" + pos[n] + ":" + pos[n + 1] + ":" + pos[n + 2] : (n < jetTokenCount - 2 ? "POS012=" + pos[n] + ":" + pos[n + 1] + ":" : "POS012=" + pos[n] + "::"), "prevTag=" + (n > 0 ? tag[n - 1] : ""), "currWord=" + word[n], "W-1W0=" + (n > 0 ? word[n - 1] : "") + ":" + word[n], "W0W1=" + word[n] + ":" + (n < jetTokenCount - 1 ? word[n + 1] : "")};
        return stringArray;
    }

    public static void loadModel() {
        String string = "C:/Documents and Settings/Ralph Grishman/My Documents/HMM/Chunk/chunk model.txt";
        Chunker.loadModel(string);
    }

    public static void loadModel(String string) {
        try {
            model = new SuffixSensitiveGISModelReader(new File(string)).getModel();
            System.out.println("GIS model loaded.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        Chunker.loadModel();
        JetTest.initializeFromConfig("ME Chunk.properties");
        new Console();
    }

    static {
        trace = false;
    }
}

