/*
 * Decompiled with CFR 0.152.
 */
package Jet.Sense;

import Jet.Lex.Lexicon;
import Jet.Lisp.FeatureSet;
import Jet.Sense.CategorySorter;
import Jet.SenseResourceException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.PointerUtils;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.dictionary.Dictionary;

public class SenseUtils {
    public static CategorySorter ontology = null;
    public static Dictionary dict = null;
    public static POS defaultPOS = POS.NOUN;
    private static boolean debug = false;

    public static boolean areSynonyms(Synset synset, Synset synset2) throws JWNLException, SenseResourceException {
        if (synset == null || synset2 == null) {
            return false;
        }
        if (synset.equals((Object)synset2)) {
            return true;
        }
        if (SenseUtils.isHyponymOf(synset, synset2)) {
            return true;
        }
        return SenseUtils.isHyponymOf(synset2, synset);
    }

    public static boolean isHyponymOf(Synset synset, Synset synset2) throws JWNLException {
        PointerTargetNodeList pointerTargetNodeList = PointerUtils.getDirectHyponyms((Synset)synset2);
        Iterator iterator = pointerTargetNodeList.iterator();
        while (iterator.hasNext()) {
            PointerTargetNode pointerTargetNode = (PointerTargetNode)iterator.next();
            Synset synset3 = pointerTargetNode.getSynset();
            if (!synset.equals((Object)synset3)) continue;
            return true;
        }
        return false;
    }

    public static long offsetFromSenseNum(String string, POS pOS, int n) throws JWNLException {
        IndexWord indexWord = dict.lookupIndexWord(pOS, string);
        if (indexWord == null) {
            return -1L;
        }
        Synset synset = indexWord.getSense(n);
        return synset.getOffset();
    }

    public static Synset[] getSynsets(String string) throws JWNLException {
        String string2 = "";
        try {
            IndexWord indexWord;
            string2 = SenseUtils.getBaseForm(defaultPOS, string);
            if (string2 == null) {
                string2 = string;
            }
            if ((indexWord = dict.lookupIndexWord(defaultPOS, string2)) == null) {
                return null;
            }
            return indexWord.getSenses();
        }
        catch (Exception exception) {
            System.out.println("Error in SenseUtils.getSynsets for token " + string2);
            System.out.println("  " + exception);
            return null;
        }
    }

    public static Synset[] getSynsets(String string, POS pOS) throws JWNLException {
        IndexWord indexWord;
        String string2 = SenseUtils.getBaseForm(pOS, string);
        if (string2 == null) {
            string2 = string;
        }
        if ((indexWord = dict.lookupIndexWord(pOS, string2)) == null) {
            return null;
        }
        return indexWord.getSenses();
    }

    public static Synset[] getSynsetsForBaseForm(String string) throws JWNLException {
        IndexWord indexWord = dict.lookupIndexWord(defaultPOS, string);
        if (indexWord == null) {
            return null;
        }
        return indexWord.getSenses();
    }

    public static FeatureSet getPOSDef(POS pOS, String string) {
        FeatureSet[] featureSetArray = Lexicon.lookUp(new String[]{string});
        if (featureSetArray == null) {
            return null;
        }
        String string2 = pOS == POS.VERB ? ";v;tv;ving;ven;" : ";n;";
        for (int i = 0; i < featureSetArray.length; ++i) {
            String string3 = (String)featureSetArray[i].get("cat");
            if (string3 == null || string2.indexOf(";" + string3 + ";") < 0) continue;
            return featureSetArray[i];
        }
        return null;
    }

    public static String[] getAllPOS(String string) {
        String string2 = string.toLowerCase();
        FeatureSet[] featureSetArray = Lexicon.lookUp(new String[]{string2});
        if (featureSetArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[featureSetArray.length];
        for (int i = 0; i < featureSetArray.length; ++i) {
            stringArray[i] = (String)featureSetArray[i].get("cat");
        }
        return stringArray;
    }

    public static String getBaseForm(POS pOS, String string) {
        FeatureSet featureSet = SenseUtils.getPOSDef(pOS, string);
        if (featureSet == null) {
            return null;
        }
        FeatureSet featureSet2 = (FeatureSet)featureSet.get("pa");
        if (featureSet2 == null) {
            return null;
        }
        String string2 = (String)featureSet2.get("head");
        return string2;
    }

    public static HashSet synHashSet(Synset[] synsetArray) {
        HashSet<Synset> hashSet = new HashSet<Synset>();
        for (int i = 0; i < synsetArray.length; ++i) {
            hashSet.add(synsetArray[i]);
        }
        return hashSet;
    }

    public static Synset[] synsetUnion(Synset[] synsetArray, Synset[] synsetArray2) {
        HashSet<Synset> hashSet = new HashSet<Synset>(Arrays.asList(synsetArray));
        hashSet.addAll(Arrays.asList(synsetArray2));
        return hashSet.toArray(synsetArray);
    }

    public static Object keyFromSenseNum(String string, POS pOS, int n) throws JWNLException {
        IndexWord indexWord = dict.lookupIndexWord(pOS, string);
        if (indexWord == null) {
            return null;
        }
        if (indexWord.getSenseCount() < n) {
            return null;
        }
        Synset synset = indexWord.getSense(n);
        return synset.getKey();
    }

    public static Object keyFromOffset(long l, POS pOS) throws JWNLException {
        Synset synset = dict.getSynsetAt(pOS, l);
        return synset.getKey();
    }

    public static Synset synsetFromSenseNum(String string, POS pOS, int n) throws JWNLException {
        IndexWord indexWord = dict.lookupIndexWord(pOS, string);
        if (indexWord == null) {
            return null;
        }
        if (indexWord.getSenseCount() < n) {
            return null;
        }
        Synset synset = indexWord.getSense(n);
        return synset;
    }
}

