/*
 * Decompiled with CFR 0.152.
 */
package Jet.Concepts;

import Jet.Concepts.Concept;
import Jet.Concepts.TransferableTreeNode;
import Jet.Concepts.Word;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ConceptHierarchy
extends JTree
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    final boolean DEBUG = false;
    Hashtable concepts = new Hashtable();
    Hashtable conceptsInv = new Hashtable();
    Hashtable words = new Hashtable();
    Hashtable wordsInv = new Hashtable();
    private Component owner;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private TreePath selectedTreePath = null;
    private DefaultMutableTreeNode selectedNode = null;
    private Point cursorLocation = null;

    public ConceptHierarchy() {
        super(new Concept("UNIVERSE"));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setEditable(true);
        this.dragSource = DragSource.getDefaultDragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        this.dropTarget = new DropTarget(this, this);
    }

    public ConceptHierarchy(File file) {
        this();
        this.readHierarchy(file);
    }

    public void setOwner(Component component) {
        this.owner = component;
    }

    public Concept getConceptByName(String string) {
        Object v = this.concepts.get(string);
        if (v == null) {
            return null;
        }
        return (Concept)v;
    }

    public Concept getConceptByNameIgnoreCase(String string) {
        Enumeration enumeration = this.concepts.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (Concept)this.concepts.get(string2);
        }
        return null;
    }

    public Concept getConceptFor(String string) {
        Word word = this.getWordByName(string);
        if (word != null) {
            return (Concept)word.getParent();
        }
        return null;
    }

    public Word getWordByName(String string) {
        Object v = this.words.get(string);
        if (v == null) {
            return null;
        }
        return (Word)v;
    }

    public Word getWordByNameIgnoreCase(String string) {
        Enumeration enumeration = this.words.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.equalsIgnoreCase(string)) continue;
            return (Word)this.words.get(string2);
        }
        return null;
    }

    public static boolean isa(Concept concept, Concept concept2) {
        return concept2.isNodeChild(concept);
    }

    public static boolean isaStar(Concept concept, Concept concept2) {
        return concept.isNodeAncestor(concept2);
    }

    public boolean addConcept(Concept concept, Concept concept2) {
        if (!this.isDuplicateConcept(concept)) {
            concept2.addConcept(concept);
            concept.setParent(concept2);
            Enumeration enumeration = concept.breadthFirstEnumerationOfConcepts();
            Enumeration enumeration2 = concept.breadthFirstEnumerationOfWords();
            this.concepts.put(concept.getName(), concept);
            this.conceptsInv.put(concept, concept.getName());
            while (enumeration.hasMoreElements()) {
                Concept concept3 = (Concept)enumeration.nextElement();
                this.concepts.put(concept3.getName(), concept3);
                this.conceptsInv.put(concept3, concept3.getName());
            }
            while (enumeration2.hasMoreElements()) {
                Word word = (Word)enumeration2.nextElement();
                this.words.put(word.getName(), word);
                this.wordsInv.put(word, word.getName());
            }
            this.updateUI();
            return true;
        }
        return false;
    }

    public boolean addWord(Word word, Concept concept) {
        if (!this.isDuplicateWord(word)) {
            concept.addWord(word);
            word.setParent(concept);
            this.words.put(word.getName(), word);
            this.wordsInv.put(word, word.getName());
            this.updateUI();
            return true;
        }
        return false;
    }

    public void newConcept(Concept concept) {
        Concept concept2 = new Concept("NEW-CONCEPT");
        this.addConcept(concept2, concept);
        this.setSelectionPath(new TreePath(concept2.getPath()));
        this.startEditingAtPath(this.getSelectionPath());
    }

    public void newWord(Concept concept) {
        Word word = new Word("New Word");
        this.addWord(word, concept);
        this.setSelectionPath(new TreePath(word.getPath()));
        this.startEditingAtPath(this.getSelectionPath());
    }

    public void removeConcept(Concept concept) {
        Concept concept2 = (Concept)concept.getParent();
        concept2.removeConcept(concept);
        Enumeration enumeration = concept.breadthFirstEnumerationOfConcepts();
        Enumeration enumeration2 = concept.breadthFirstEnumerationOfWords();
        this.concepts.remove(concept.getName());
        this.conceptsInv.remove(concept);
        while (enumeration.hasMoreElements()) {
            Concept concept3 = (Concept)enumeration.nextElement();
            this.concepts.remove(concept3.getName());
            this.conceptsInv.remove(concept3);
        }
        while (enumeration2.hasMoreElements()) {
            Word word = (Word)enumeration2.nextElement();
            this.words.remove(word.getName());
            this.wordsInv.remove(word);
        }
        this.updateUI();
    }

    public void removeWord(Word word) {
        Concept concept = (Concept)word.getParent();
        concept.removeWord(word);
        this.words.remove(word.getName());
        this.wordsInv.remove(word);
        this.updateUI();
    }

    public void clear() {
        Concept concept = (Concept)this.getModel().getRoot();
        concept.removeAllChildren();
        this.concepts.clear();
        this.conceptsInv.clear();
        this.words.clear();
        this.wordsInv.clear();
        this.updateUI();
    }

    public boolean isDuplicateConcept(Concept concept) {
        Concept concept2 = concept;
        if (this.concepts.containsKey(concept.getName())) {
            final String string = "Concept '" + concept2.getName() + "' already exists.\nNo duplicate concepts allowed.";
            if (this.owner != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ConceptHierarchy.this.owner, string, "Error -- Duplicate Concept", 0);
                    }
                });
            } else {
                System.out.println(string);
            }
            return true;
        }
        return false;
    }

    public boolean isDuplicateWord(Word word) {
        Word word2 = word;
        if (this.words.containsKey(word.getName())) {
            final String string = "Word '" + word2.getName() + "' already exists.\nNo duplicate words allowed.";
            if (this.owner != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ConceptHierarchy.this.owner, string, "Error -- Duplicate Word", 0);
                    }
                });
            } else {
                System.out.println(string);
            }
            return true;
        }
        return false;
    }

    public void readHierarchy(File file) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            this.clear();
            while ((string = bufferedReader.readLine()) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                if (!stringTokenizer.hasMoreTokens() || string.substring(0, 2).equals("//")) continue;
                String string2 = stringTokenizer.nextToken();
                Concept concept = new Concept(string2);
                if (!stringTokenizer.hasMoreTokens()) {
                    System.out.println("throw 01");
                    throw new IOException(string);
                }
                String string3 = stringTokenizer.nextToken();
                if (string3.equals("isa")) {
                    if (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        Concept concept2 = this.getConceptByName(string4);
                        if (concept2 == null) {
                            concept2 = new Concept(string4);
                            this.addConcept(concept2, (Concept)this.getModel().getRoot());
                        }
                        this.addConcept(concept, concept2);
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        System.out.println("throw 02");
                        throw new IOException(string);
                    }
                    System.out.println("throw 03");
                    throw new IOException(string);
                }
                if (string3.equals("words")) {
                    Word word;
                    int n;
                    if (!stringTokenizer.hasMoreTokens()) {
                        System.out.println("throw 04");
                        throw new IOException(string);
                    }
                    concept = this.getConceptByName(string2);
                    if (concept == null) {
                        concept = new Concept(string2);
                        this.addConcept(concept, (Concept)this.getModel().getRoot());
                    }
                    StringBuffer stringBuffer = new StringBuffer();
                    while (stringTokenizer.hasMoreTokens()) {
                        stringBuffer.append(stringTokenizer.nextToken() + " ");
                        n = stringBuffer.length();
                        if (!stringBuffer.substring(n - 2, n).equals(", ")) continue;
                        word = new Word(stringBuffer.substring(0, n - 2));
                        this.addWord(word, concept);
                        stringBuffer = new StringBuffer();
                    }
                    n = stringBuffer.length();
                    if (stringBuffer.substring(n - 2, n).equals(", ")) continue;
                    word = new Word(stringBuffer.toString().trim());
                    this.addWord(word, concept);
                    continue;
                }
                System.out.println("throw 05");
                throw new IOException(string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Error: File " + file.toString() + " not found.");
        }
        catch (IOException iOException) {
            System.err.println("Error processing file " + file.toString() + " at the following line:\n" + iOException.getMessage());
        }
    }

    public void writeHierarchy(File file) {
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            Concept concept = (Concept)this.getModel().getRoot();
            for (int i = 0; i < concept.getSubconceptCount(); ++i) {
                this.recursiveWrite(concept.getSubconceptAt(i), printWriter);
            }
        }
        catch (IOException iOException) {
            System.err.println("Error writing to file " + file.toString() + ".");
        }
    }

    private void recursiveWrite(Concept concept, PrintWriter printWriter) {
        int n;
        Concept concept2 = (Concept)concept.getParent();
        if (!concept2.equals((Concept)this.getModel().getRoot())) {
            printWriter.println(concept.getName() + " isa " + concept2.getName());
            printWriter.flush();
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (n = 0; n < concept.getWordCount(); ++n) {
            if (n == 0) {
                stringBuffer.append(concept.getWordAt(n).getName());
                continue;
            }
            stringBuffer.append(", " + concept.getWordAt(n).getName());
        }
        if (stringBuffer.length() > 0) {
            printWriter.println(concept.getName() + " words " + stringBuffer.toString());
            printWriter.flush();
        }
        for (n = 0; n < concept.getSubconceptCount(); ++n) {
            Concept concept3 = concept.getSubconceptAt(n);
            this.recursiveWrite(concept3, printWriter);
        }
    }

    public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
        this.selectedTreePath = this.getSelectionPath();
        if (this.selectedTreePath != null) {
            this.selectedNode = (DefaultMutableTreeNode)this.selectedTreePath.getLastPathComponent();
            TransferableTreeNode transferableTreeNode = new TransferableTreeNode(this.selectedNode);
            Cursor cursor = DragSource.DefaultMoveDrop;
            int n = dragGestureEvent.getDragAction();
            if (n == 1) {
                cursor = DragSource.DefaultCopyDrop;
            }
            this.dragSource.startDrag(dragGestureEvent, cursor, transferableTreeNode, this);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
    }

    public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        this.setCursor(dragSourceDragEvent);
    }

    public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        this.setCursor(dragSourceDragEvent);
    }

    public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
    }

    public void dragExit(DragSourceEvent dragSourceEvent) {
    }

    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        try {
            Serializable serializable;
            Transferable transferable = dropTargetDropEvent.getTransferable();
            if (!transferable.isDataFlavorSupported(TransferableTreeNode.DEFAULT_MUTABLE_TREENODE_FLAVOR)) {
                dropTargetDropEvent.rejectDrop();
            }
            Object object = transferable.getTransferData(TransferableTreeNode.DEFAULT_MUTABLE_TREENODE_FLAVOR);
            Point point = dropTargetDropEvent.getLocation();
            TreePath treePath = this.getPathForLocation(point.x, point.y);
            final String string = this.testDropTarget(treePath, this.selectedTreePath);
            if (string != null) {
                dropTargetDropEvent.rejectDrop();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(ConceptHierarchy.this.owner, string, "Error Moving Node", 0);
                    }
                });
                return;
            }
            Concept concept = (Concept)treePath.getLastPathComponent();
            Concept concept2 = (Concept)this.selectedNode.getParent();
            try {
                if (object instanceof Concept) {
                    serializable = (Concept)object;
                    this.removeConcept((Concept)this.selectedNode);
                    this.addConcept((Concept)serializable, concept);
                    dropTargetDropEvent.acceptDrop(2);
                } else {
                    serializable = (Word)object;
                    this.removeWord((Word)this.selectedNode);
                    this.addWord((Word)serializable, concept);
                    dropTargetDropEvent.acceptDrop(2);
                }
            }
            catch (IllegalStateException illegalStateException) {
                dropTargetDropEvent.rejectDrop();
            }
            dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            serializable = (DefaultTreeModel)this.getModel();
            ((DefaultTreeModel)serializable).reload(concept2);
            ((DefaultTreeModel)serializable).reload(concept);
            TreePath treePath2 = new TreePath(concept.getPath());
            this.expandPath(treePath2);
        }
        catch (IOException iOException) {
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            dropTargetDropEvent.rejectDrop();
        }
    }

    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        this.cursorLocation = dropTargetDragEvent.getLocation();
    }

    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    private String testDropTarget(TreePath treePath, TreePath treePath2) {
        if (treePath == null) {
            return "Invalid drop location.";
        }
        Object object = treePath.getLastPathComponent();
        if (object instanceof Word) {
            return "A word does not allow children.";
        }
        if (treePath.equals(treePath2)) {
            return "Destination cannot be same as source.";
        }
        if (treePath2.isDescendant(treePath)) {
            return "Destination cannot be a descendant of source.";
        }
        if (treePath2.getParentPath().equals(treePath)) {
            return "Destination cannot be a parent of source.";
        }
        return null;
    }

    private void setCursor(DragSourceDragEvent dragSourceDragEvent) {
        if (this.cursorLocation == null) {
            return;
        }
        TreePath treePath = this.getPathForLocation(this.cursorLocation.x, this.cursorLocation.y);
        DragSourceContext dragSourceContext = dragSourceDragEvent.getDragSourceContext();
        if (this.testDropTarget(treePath, this.selectedTreePath) == null) {
            dragSourceContext.setCursor(DragSource.DefaultMoveDrop);
        } else {
            dragSourceContext.setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    void printHashtables() {
        System.out.println("\n***concepts***\n");
        Enumeration enumeration = this.concepts.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
        System.out.println("\n***conceptsInv***\n");
        Enumeration enumeration2 = this.conceptsInv.elements();
        while (enumeration2.hasMoreElements()) {
            System.out.println(enumeration2.nextElement());
        }
        System.out.println("\n***words***\n");
        Enumeration enumeration3 = this.words.elements();
        while (enumeration3.hasMoreElements()) {
            System.out.println(enumeration3.nextElement());
        }
        System.out.println("\n***wordsInv***\n");
        Enumeration enumeration4 = this.wordsInv.elements();
        while (enumeration4.hasMoreElements()) {
            System.out.println(enumeration4.nextElement());
        }
    }
}

