/*
 * Decompiled with CFR 0.152.
 */
package AceJet;

import AceJet.Ace;
import AceJet.AceDocument;
import AceJet.EDTtype;
import AceJet.EDTtypeData;
import AceJet.Gazetteer;
import AceJet.LearnRelations;
import AceJet.Mention;
import Jet.Chunk.Chunker;
import Jet.Control;
import Jet.JetTest;
import Jet.Parser.SynFun;
import Jet.Pat.Pat;
import Jet.Refres.Resolve;
import Jet.Sense.Category;
import Jet.Sense.SenseUtils;
import Jet.Tipster.Annotation;
import Jet.Tipster.ExternalDocument;
import Jet.Tipster.Span;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.Synset;

public class EDTtypeEnsemble
extends EDTtype {
    static int mctDecided = 0;
    static int wsdDecided = 0;
    public static PrintStream out = System.out;
    static final String fileList = "C:/Documents and Settings/Ralph Grishman/My Documents/ACE/acedata2/nwiresplit_ACEsep02dev/heldbacknwire.txt";
    static String currentDoc;
    static boolean wsdOnlyAsBackup;

    public static void main(String[] stringArray) throws IOException {
        String string = "";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        boolean bl = wsdOnlyAsBackup = string.indexOf(98) >= 0;
        if (wsdOnlyAsBackup) {
            System.out.println("Using WSD only for words not found in type dictionary.");
        } else {
            System.out.println("Choosing WSD or MCT based on confidence values.");
        }
        JetTest.initializeFromConfig("props/ME ace.properties");
        Ace.gazetteer = new Gazetteer();
        Ace.gazetteer.load();
        Chunker.loadModel();
        EDTtypeEnsemble.readTypeDict("C:/Documents and Settings/Ralph Grishman/My Documents/ACE/new EDT type dict.txt");
        Pat.trace = false;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(fileList));
        int n = 0;
        while ((currentDoc = bufferedReader.readLine()) != null) {
            System.out.println("\nProcessing document " + ++n + ": " + currentDoc);
            out.println("\nProcessing document " + n + ": " + currentDoc);
            String string2 = currentDoc + ".sgm";
            doc = new ExternalDocument("sgml", string2);
            doc.setAllTags(true);
            doc.open();
            Control.processDocument(doc, null, false, n);
            EDTtypeEnsemble.collectTokens();
            String string3 = AceDocument.ace2004 ? ".apf.xml" : ".sgm.tmx.rdc.xml";
            String string4 = currentDoc + string3;
            AceDocument aceDocument = new AceDocument(string2, string4);
            LearnRelations.findEntityMentions(aceDocument);
            EDTtypeEnsemble.processMentions(doc);
        }
        System.out.println(trainingMentions + " training mentions");
        System.out.println(correct + " correct predictions, " + incorrect + " incorrect");
        System.out.println(unknown + " unknown");
        System.out.println(wsdDecided + " decided by WSD, " + mctDecided + " decided by MCT.");
    }

    static void processMentions(ExternalDocument externalDocument) {
        Vector vector = Resolve.gatherMentions(externalDocument, new Span(0, externalDocument.length()));
        for (int i = 0; i < vector.size(); ++i) {
            Annotation annotation = (Annotation)vector.get(i);
            Annotation annotation2 = Resolve.getHeadC(annotation);
            String string = (String)annotation2.get("cat");
            if (string.equals("pro") || string.equals("det") || string.equals("name")) continue;
            String string2 = Resolve.normalizeName(externalDocument.text(annotation2));
            string2 = string2.toLowerCase();
            Mention mention = (Mention)LearnRelations.mentionStartMap.get(new Integer(annotation2.start()));
            String string3 = "OTHER";
            if (mention != null) {
                string3 = mention.type;
            }
            String string4 = "";
            string4 = EDTtypeEnsemble.getTypeSubtype(externalDocument, null, annotation);
            if (string4.equals(string3)) {
                ++correct;
                continue;
            }
            ++incorrect;
            System.out.print("Mention: " + externalDocument.text(annotation));
            System.out.println(" predict " + string4 + ", should be " + string3);
        }
    }

    public static String getTypeSubtype(ExternalDocument externalDocument, Annotation annotation, Annotation annotation2) {
        Annotation annotation3 = Resolve.getHeadC(annotation2);
        String string = EDTtype.getTypeSubtype(externalDocument, annotation, annotation2);
        String string2 = "";
        if (string.trim().equalsIgnoreCase("OTHER")) {
            String string3 = Resolve.normalizeName(externalDocument.text(annotation3).trim());
            String string4 = SynFun.getName(externalDocument, annotation2);
            String string5 = (String)annotation3.get("cat");
            if (string4 != null) {
                return "OTHER";
            }
            if (string3.equals("us")) {
                return "OTHER";
            }
            try {
                Synset[] synsetArray = SenseUtils.getSynsets(externalDocument.text(annotation3));
                if (synsetArray == null) {
                    return "OTHER";
                }
                Category category = SenseUtils.ontology.categorize(synsetArray[0]);
                if (category == null) {
                    return "OTHER";
                }
                string = category.getLabel().toUpperCase().trim();
                if (string != null) {
                    System.out.println("Using WSD for entity typing.");
                    if (string.equalsIgnoreCase("WEAPON") || string.equalsIgnoreCase("VEHICLE")) {
                        string = string.substring(0, 3);
                    }
                    if ((string2 = EDTtypeData.bestSubtype(string)).length() != 0) {
                        return EDTtype.typeAndSubtype(string, string2);
                    }
                }
            }
            catch (JWNLException jWNLException) {
                // empty catch block
            }
        }
        return string;
    }

    static {
        wsdOnlyAsBackup = false;
    }
}

