/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.TIntHash;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TIntHashSet
extends TIntHash
implements Serializable {
    public boolean add(int val) {
        int index = this.insertionIndex(val);
        if (index < 0) {
            return false;
        }
        byte previousState = this._states[index];
        this._set[index] = val;
        this._states[index] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldSet[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._states[index] = 1;
        }
    }

    public int[] toArray() {
        int[] result = new int[this.size()];
        int[] set = this._set;
        byte[] states = this._states;
        int i = states.length;
        int j = 0;
        while (i-- > 0) {
            if (states[i] != 1) continue;
            result[j++] = set[i];
        }
        return result;
    }

    public void clear() {
        super.clear();
        int[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            set[i] = 0;
            states[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntHashSet)) {
            return false;
        }
        TIntHashSet that = (TIntHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TIntProcedure(this, that){
            private final /* synthetic */ TIntHashSet this$0;
            private final /* synthetic */ TIntHashSet val$that;

            public final boolean execute(int value) {
                return this.val$that.contains(value);
            }
            {
                this.val$that = val$that;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TIntHashSet tIntHashSet) {
            }
        });
    }

    public boolean remove(int val) {
        int index = this.index(val);
        if (index >= 0) {
            this.removeAt(index);
            return true;
        }
        return false;
    }

    public boolean containsAll(int[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(int[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(int[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(int[] array) {
        boolean changed = false;
        Arrays.sort(array);
        int[] set = this._set;
        byte[] states = this._states;
        int i = set.length;
        while (i-- > 0) {
            if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
            this.remove(set[i]);
            changed = true;
        }
        return changed;
    }

    private final void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        class WriteProcedure
        implements TIntProcedure {
            IOException e;
            private final /* synthetic */ TIntHashSet this$0;
            private final /* synthetic */ ObjectOutputStream val$stream;

            public boolean execute(int value) {
                try {
                    this.val$stream.writeInt(value);
                }
                catch (IOException ioe) {
                    this.e = ioe;
                    return false;
                }
                return true;
            }

            /* synthetic */ WriteProcedure(TIntHashSet this$0, ObjectOutputStream val$stream) {
                this.val$stream = val$stream;
                this.this$0 = this$0;
                this.constructor$0(this$0);
            }

            private final void constructor$0(TIntHashSet tIntHashSet) {
            }
        }
        WriteProcedure writeProcedure = new WriteProcedure(this, stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.e;
        }
    }

    private final void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            int val = stream.readInt();
            this.add(val);
        }
    }

    public TIntHashSet() {
    }

    public TIntHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TIntHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TIntHashSet(int[] array) {
        this(array.length);
        this.addAll(array);
    }
}

