package Jet;

import java.io.*;

import Jet.Sense.*;

import net.didion.jwnl.*;

/**
 * Initializes JWNL and the sense corpus.
 * @author M. David Westbrook
 * Apr 4, 2004
 *  */
public class SenseResources {
//	public static SenseIndex currentSenseIndex = null;
	
	/**
	 * Retrieves the location of the JWNL initialization file from
	 * the Jet config file, initializes JWNL, creates an instance of a JWNL Dictionary,
	 * and creates an instance of an ACECategorySorter.
	 * 
     * @throws JWNLException Indicates a problem initializing JWNL
     * @throws SenseResourceException Indicates a problem retrieving initialization information
     * from the Jet config file
     * @throws IOException Indicates a problem retrieving resources from the file system
     * @throws ClassNotFoundException Indicates a problem with deserializing a SenseCorpus
     */
    public static void initializeSenseResources() 
		throws JWNLException, SenseResourceException, 
		IOException, ClassNotFoundException {
		FileInputStream jwnlConfig = null;
		String dataPath, jwnlConfigFile, corpusIndexFile, ontologyPath;
		System.out.println("Initializing sense resources.");
		dataPath = JetTest.config.getProperty("Jet.dataPath");
		jwnlConfigFile = JetTest.config.getProperty("Sense.jwnlConfigFile");
		//corpusIndexFile = JetTest.config.getProperty("Sense.corpusIndex");
		if (dataPath==null)
			throw new SenseResourceException("Sense resource path " +
				"not found in config file: Jet.datapath");
		if (jwnlConfigFile==null)
			throw new SenseResourceException("Sense resource path " +
				"not found in config file: Sense.jwnlConfigFile");
//		if (corpusIndexFile==null)
//			throw new SenseResourceException("Sense resource path " +
//				"not found in config file: Sense.corpusIndex");
		
		// JWNL initialization:
		File f = new File(dataPath, jwnlConfigFile);
		jwnlConfig = new FileInputStream(f);
		JWNL.initialize(jwnlConfig);
		jwnlConfig.close();
		SenseUtils.dict = net.didion.jwnl.dictionary.Dictionary.getInstance();
		SenseUtils.ontology = new ACECategorySorter();
		
		// Sense corpus initialization
//		File c = new File(dataPath, corpusIndexFile);
//		SenseUtils.corpus = SenseCorpusFile.deserializeSenseCorpus(c);
		
//			System.out.println("Reading ACECategorySorter instance at " + dataPath + ontologyPath);
//			File d = new File(dataPath, ontologyPath);
//			ACECategorySorter sorter = null;
//			ObjectInputStream objReader = null;
//			FileInputStream sorterFile = null;
//	
//			sorterFile = new FileInputStream(d);
//			objReader = new ObjectInputStream(sorterFile);	
	}
}
