package Jet.Sense;

import java.util.HashSet;
import java.util.Iterator;

import java.io.Serializable;

import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Synset;

/**
 * Category represents a grouping of WordNet Synsets into a more general category.
 * 
 * @author M. David Westbrook
 * Jun 18, 2004
 *  */
public class Category implements Serializable {
	private String label; // The name of this Category (for example, the ACE entity type)
	private HashSet synsets; // The synsets that belong to this Category.
	private POS  pos; // The part-of-speech of the Synsets in this Category
	static final long serialVersionUID = 1; // Helps with serialization
	
	public Category(String l, POS p) {
		synsets = new HashSet();
		pos = p;
		label = l;
	}
	
	/**
	 * Adds a Synset to the set of Synsets contained in this category.
	 * 
     * @param sense The Synset to be added to this category.
     */
    public void add(Synset sense) {
		synsets.add(new Long(sense.getOffset()));
	}
	
	/**
	 * Indicates whether a given Synset falls into this Category
     * @param sense The Synset to check for. 
     * @return True if sense is in this Category, false if it is not.
     */
    public boolean contains(Synset sense) {
		return synsets.contains(new Long(sense.getOffset()));
	}

    public boolean equals(Object other) {
		// TODO: For now we're trusting that Categories with the same label are the same.
		// Should add check that synsets are the same.
		return ((Category) other).getLabel().equals(label);
	}
	
	public String toString() {
		Iterator syns = synsets.iterator();
		StringBuffer result = new StringBuffer("*** " + label + " ***\n");
		while (syns.hasNext()) {
			Long offset = (Long) syns.next();
			Synset next;
            try {
                next = SenseUtils.dict.getSynsetAt(pos, offset.longValue());
				result.append(next + "\n");
            } catch (JWNLException e) {
            	result.append("Java WordNet interface problem: "+e.getMessage()+"\n");
            }
		}
		return result.toString();
	}
	
    /**
     * @return The name of this Category
     */
    public String getLabel() {
		return label;
    }
}
