package AceJet;

import java.util.*;
import java.io.*;

import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.*;

/**
 *  an Ace relation mention, with information from the ACE key.
 */

public class AceRelationMention {
	
	/**
	 *  the ID of the mention
	 */
	public String id;
	/**
	 *  arg1:  an AceEntityMention
	 */
	public AceEntityMention arg1;
	/**
	 *  arg2:  an AceEntityMention
	 */
	public AceEntityMention arg2;

	public AceRelationMention (String id, AceEntityMention arg1, AceEntityMention arg2) {
		this.id = id;
		this.arg1 = arg1;
		this.arg2 = arg2;
	}
	
	/**
	 *  create an AceEntityMention from the information in the APF file.
	 *  @param mentionElement the XML element from the APF file containing
	 *                       information about this mention
	 *  @param acedoc        the AceDocument to which this relation mention
	 *                       belongs
	 */
	
	public AceRelationMention (Element mentionElement, AceDocument acedoc) {
				id = mentionElement.getAttribute("ID");
				NodeList arguments = mentionElement.getElementsByTagName("rel_mention_arg");
				for (int j=0; j<arguments.getLength(); j++) {
					Element argument = (Element) arguments.item(j);
					String mentionid = argument.getAttribute(
						AceDocument.ace2004 ? "ENTITYMENTIONID" : "MENTIONID");
					String argnum = argument.getAttribute("ARGNUM");
					if (argnum.equals("1")) {
						arg1 = acedoc.findEntityMention(mentionid);
					} else if (argnum.equals("2")) {
						arg2 = acedoc.findEntityMention(mentionid);
					} else {
						System.out.println ("*** invalid ARGNUM for relation");
					}
				}
		}
		
		public void write (PrintWriter w) {
			// LDCLEXICALCONDITION is not scored but is required for validation
			w.println("      <relation_mention ID=\"" + id + "\" LDCLEXICALCONDITION=\"Formulaic\">");
			writeMentionArg (w, 1, arg1);
			writeMentionArg (w, 2, arg2);
			w.println("      </relation_mention>");
		}
		
		private void writeMentionArg (PrintWriter w, int argnum, AceEntityMention arg) {
			String keyword = AceDocument.ace2004 ? "ENTITYMENTIONID" : "MENTIONID";
			w.println("        <rel_mention_arg " + keyword + "=\"" + arg.id + 
			          "\" ARGNUM=\"" + argnum + "\">");
			w.println("          <extent>");
			w.print  ("            <charseq START=\"" + arg.extent.start() + 
			          "\" END=\"" + arg.extent.end() + "\">");
			w.print  (arg.text);
			w.println(            "</charseq>");
			w.println("          </extent>");
			w.println("        </rel_mention_arg>");
		}
			
}