package AceJet;

import java.util.*;
import java.io.*;

import org.w3c.dom.*;
import org.xml.sax.*;
import javax.xml.parsers.*;

/**
 *  an Ace Relation, with information from the ACE key.
 */

public class AceRelation {
	
	/**
	 *  the type of the relation:  
	 */
	public String type;
	/**
	 *  the subtype of the relation
	 */
	public String subtype;
	/**
	 *  the ID of the relation
	 */
	public String id;
	/**
	 *  the class of the mention:  explicit or implicit (not for ace2004)
	 */
	public String relClass;
	/**
	 *  arg1 of the relation:  an entity
	 */
	public AceEntity arg1;
	/**
	 *  arg2 of the relation:  an entity
	 */
	public AceEntity arg2;
	/**
	 *  a list of the mentions of this relation (each of type AceRelationMention)
	 */
	public ArrayList mentions = new ArrayList();

	public AceRelation (String id, String type, String subtype, String relClass,
	    AceEntity arg1, AceEntity arg2) {
		this.id = id;
		this.type = type;
		this.subtype = subtype;
		this.relClass = relClass;
		this.arg1 = arg1;
		this.arg2 = arg2;
	}
	
	/**
	 *  create an AceRelation from the information in the APF file.
	 *  @param relationElement the XML element from the APF file containing
	 *                       information about this entity
	 *  @param JEToffsetMap  a mapping from ACE offsets (excluding XML tags)
	 *                       to offsets in the document (including MXL tags)
	 *  @param fileText      the text of the document, including XML tags
	 */
	
	public AceRelation (Element relationElement, AceDocument acedoc) {
			id = relationElement.getAttribute("ID");
			type = relationElement.getAttribute("TYPE");
			subtype = relationElement.getAttribute("SUBTYPE");
			relClass = relationElement.getAttribute("CLASS");
			// record arguments
			NodeList arguments = relationElement.getElementsByTagName("rel_entity_arg");
			for (int j=0; j<arguments.getLength(); j++) {
				Element argument = (Element) arguments.item(j);
				String entityid = argument.getAttribute("ENTITYID");
				String argnum = argument.getAttribute("ARGNUM");
				if (argnum.equals("1")) {
					arg1 = acedoc.findEntity(entityid);
				} else if (argnum.equals("2")) {
					arg2 = acedoc.findEntity(entityid);
				} else {
					System.out.println ("*** invalid ARGNUM for relation");
				}
			}
			/*
			NodeList mentionLists = relationElement.getElementsByTagName("relation_mentions");
			if (mentionLists.getLength() != 1) {
				System.out.println ("*** missing or multiple 'relation_mentions' tags");
				return;
			}
			Element mentionList = (Element) mentionLists.item(0);
			NodeList mentionElements = mentionList.getElementsByTagName("relation_mention");
			*/
			NodeList mentionElements = relationElement.getElementsByTagName("relation_mention");
			for (int j=0; j<mentionElements.getLength(); j++) {
				Element mentionElement = (Element) mentionElements.item(j);
				AceRelationMention mention = new AceRelationMention (mentionElement, acedoc);
				addMention(mention);
			}			
	}
	
	void addMention (AceRelationMention mention) {
		mentions.add(mention);
	}
	
	public void write (PrintWriter w) {
		w.print   ("  <relation ID=\"" + id + "\" TYPE=\"" + type + "\"");
		if (subtype != null && !subtype.equals(""))
		  w.print (" SUBTYPE=\"" + subtype + "\"");
		if (!AceDocument.ace2004)
			w.print (" CLASS=\"" + relClass + "\"");
		w.println (">");
		w.println ("    <rel_entity_arg ENTITYID=\"" + arg1.id + "\" ARGNUM=\"1\" />");
		// w.println ("    </rel_entity_arg>");
		w.println ("    <rel_entity_arg ENTITYID=\"" + arg2.id + "\" ARGNUM=\"2\" />");
		// w.println ("    </rel_entity_arg>");
		if (!AceDocument.ace2004) w.println ("    <relation_mentions>");
		for (int i=0; i<mentions.size(); i++) {
			AceRelationMention mention = (AceRelationMention) mentions.get(i);
			mention.write(w);
		}
		if (!AceDocument.ace2004) w.println ("    </relation_mentions>");
		w.println ("  </relation>");
	}
}