package Jet.Refres;

import java.util.*;
import java.io.*;

import Jet.JetTest;
import Jet.Control;
import Jet.Pat.Pat;
import Jet.Lisp.*;
import Jet.Tipster.*;
import Jet.Chunk.Chunker;

import AceJet.Gazetteer;
import AceJet.WordNetInterface;

/**
 *  evaluate reference resolution procedure against a key file
 *  with references annotated.
 */

public class CorefWriter {
	
	static final String home =
	    "C:/Documents and Settings/Ralph Grishman/My Documents/";
	static final String ACEdir = home + "ACE/";
	static final String collection = home + "Sekine/input/Duc2004/files.txt";
	static final String dictFile = ACEdir + "EDT type dict.txt";
	
	public static void main (String[] args) throws IOException {
		// initialize Jet
		System.out.println("Starting ACE Jet...");
		JetTest.initializeFromConfig("ME ace.properties");
		// JetTest.initializeFromConfig("ace parser.properties");
		Chunker.loadModel();
		// load ACE type dictionary and gazetteer
		AceJet.EDTtype.readTypeDict(dictFile);
		AceJet.Ace.gazetteer = new Gazetteer();
		AceJet.Ace.gazetteer.load(ACEdir + "loc.dict");
		// turn off traces
		Pat.trace = false;
		Resolve.trace = false;
		// open text collection
		DocumentCollection col = new DocumentCollection(collection);
		col.open();
		for (int docCount = 0; docCount < col.size(); docCount++) {
			// process file 'currentDoc'
			// if (docCount > 1) continue;
			ExternalDocument doc = col.get(docCount);
			System.out.println ("\nProcessing document " + docCount + ": " + doc.fileName());
			// read test document
			// doc.setAllTags(true);
			doc.open();
			// process document
			// doc.annotateWithTag("TEXT");
			AceJet.Ace.monocase = AceJet.Ace.allLowerCase(doc);
			Control.processDocument (doc, null, docCount == 0, docCount);
			buildMentionsFromEntities (doc);
			doc.setSGMLtags(new String[] {"mention"});
		}
		// write new collection with mention tags
		col.saveAs(home + "Sekine/output/Duc2004/files.txt");
	}
	
	private static void buildMentionsFromEntities (Document doc) {
		Vector entities = doc.annotationsOfType("entity");
		if (entities == null) return;
		for (int ientity = 0; ientity < entities.size(); ientity++) {
			Annotation entity = (Annotation) entities.get(ientity);
			Vector mentions = (Vector) entity.get("mentions");
			for (int imention = 0; imention < mentions.size(); imention++) {
				Annotation mention = (Annotation) mentions.get(imention);
				Annotation mentionHead = Resolve.getHeadC(mention);
				doc.annotate("mention", mentionHead.span(), new FeatureSet("entity", new Integer(ientity)));
			}
		}
	}
	
}