/*
 * Decompiled with CFR 0.152.
 */
package tratz.featgen.fer;

import java.util.Set;
import tratz.featgen.fer.AbstractWordNetFER;
import tratz.jwni.IndexEntry;
import tratz.jwni.POS;
import tratz.jwni.Sense;
import tratz.jwni.WordNet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynonymsFER
extends AbstractWordNetFER {
    private static final long serialVersionUID = 1L;

    @Override
    public Set<String> generateFeatures(String input, String type, Set<String> productions) {
        IndexEntry entry;
        POS pos = this.getPosForType(type);
        if (pos != null && (entry = WordNet.getInstance().lookupIndexEntry(pos, input)) != null) {
            Sense[] senses = entry.getSenses();
            for (int i = 0; i < this.mMaxSenseNum && i < senses.length; ++i) {
                Sense sense = senses[i];
                for (Sense.Key key : sense.getKeys()) {
                    productions.add(key.getLemma());
                }
            }
        }
        return productions;
    }
}

