/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import net.didion.jwnl.JWNLRuntimeException;
import net.didion.jwnl.util.DeepCloneable;

public class TypeCheckingList
implements List,
DeepCloneable {
    private List _list;
    private Class _type;
    private Collection _lastCheckedCollection = null;

    public TypeCheckingList(Class clazz) {
        this(new ArrayList(), clazz);
    }

    public TypeCheckingList(List list, Class clazz) {
        this.init(list, clazz);
    }

    public TypeCheckingList(List list, Class clazz, Class clazz2) {
        if (!clazz2.isAssignableFrom(clazz)) {
            throw new JWNLRuntimeException("UTILS_EXCEPTION_001", new Object[]{clazz, clazz2});
        }
        this.init(list, clazz);
    }

    private void init(List list, Class clazz) {
        this._type = clazz;
        if (!list.isEmpty()) {
            this.typecheck(list);
        }
        this._list = list;
    }

    public Class getType() {
        return this._type;
    }

    private List getList() {
        return this._list;
    }

    public Object clone() throws CloneNotSupportedException {
        return new TypeCheckingList(this.copyBackingList(), this.getType());
    }

    protected List copyBackingList() throws CloneNotSupportedException {
        try {
            Method method = this.getList().getClass().getMethod("clone", null);
            return (List)method.invoke((Object)this.getList(), null);
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException();
        }
    }

    public Object deepClone() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(Object object) {
        return object instanceof TypeCheckingList && super.equals(object);
    }

    public boolean add(Object object) {
        this.typecheck(object);
        return this.getList().add(object);
    }

    public void add(int n, Object object) {
        this.typecheck(object);
        this.getList().add(n, object);
    }

    public boolean addAll(Collection collection) {
        this.typecheck(collection);
        return this.getList().addAll(collection);
    }

    public boolean addAll(int n, Collection collection) {
        this.typecheck(collection);
        return this.getList().addAll(n, collection);
    }

    public boolean contains(Object object) {
        try {
            this.typecheck(object);
            return this.getList().contains(object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean containsAll(Collection collection) {
        try {
            this.typecheck(collection);
            return this.getList().containsAll(collection);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object set(int n, Object object) {
        this.typecheck(object);
        return this.getList().set(n, object);
    }

    public int indexOf(Object object) {
        try {
            this.typecheck(object);
            return this.getList().indexOf(object);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int lastIndexOf(Object object) {
        try {
            this.typecheck(object);
            return this.getList().lastIndexOf(object);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public boolean remove(Object object) {
        try {
            this.typecheck(object);
            return this.getList().remove(object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ListIterator listIterator() {
        return this.getTypeCheckingListIterator();
    }

    public ListIterator listIterator(int n) {
        return this.getTypeCheckingListIterator(n);
    }

    protected TypeCheckingListIterator getTypeCheckingListIterator() {
        return this.getTypeCheckingListIterator(0);
    }

    protected TypeCheckingListIterator getTypeCheckingListIterator(int n) {
        return new TypeCheckingListIterator(this.getList().listIterator(n));
    }

    public int size() {
        return this.getList().size();
    }

    public boolean isEmpty() {
        return this.getList().isEmpty();
    }

    public Iterator iterator() {
        return this.getList().iterator();
    }

    public Object[] toArray() {
        return this.getList().toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.getList().toArray(objectArray);
    }

    public boolean removeAll(Collection collection) {
        return this.getList().removeAll(collection);
    }

    public boolean retainAll(Collection collection) {
        return this.getList().retainAll(collection);
    }

    public void clear() {
        this.getList().clear();
    }

    public Object get(int n) {
        return this.getList().get(n);
    }

    public Object remove(int n) {
        return this.getList().remove(n);
    }

    public List subList(int n, int n2) {
        return this.getList().subList(n, n2);
    }

    private void typecheck(Object object) {
        if (!this.getType().isInstance(object)) {
            throw new JWNLRuntimeException("UTILS_EXCEPTION_003", this.getType());
        }
    }

    private void typecheck(Collection collection) {
        if (collection != this._lastCheckedCollection) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.typecheck(iterator.next());
            }
        }
        this._lastCheckedCollection = collection;
    }

    public final class TypeCheckingListIterator
    implements ListIterator {
        private ListIterator _itr;

        private TypeCheckingListIterator(ListIterator listIterator) {
            this._itr = listIterator;
        }

        public Class getType() {
            return TypeCheckingList.this.getType();
        }

        public void set(Object object) {
            TypeCheckingList.this.typecheck(object);
            this.getListIterator().set(object);
        }

        public void add(Object object) {
            TypeCheckingList.this.typecheck(object);
            this.getListIterator().add(object);
        }

        public boolean hasNext() {
            return this.getListIterator().hasNext();
        }

        public Object next() {
            return this.getListIterator().next();
        }

        public boolean hasPrevious() {
            return this.getListIterator().hasPrevious();
        }

        public Object previous() {
            return this.getListIterator().previous();
        }

        public int nextIndex() {
            return this.getListIterator().nextIndex();
        }

        public int previousIndex() {
            return this.getListIterator().previousIndex();
        }

        public void remove() {
            this.getListIterator().remove();
        }

        private ListIterator getListIterator() {
            return this._itr;
        }
    }
}

